/*
	squelette de visualisation a completer
	
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <time.h>

#include "struct.h"
#include "camera.h"
#include "source.h"
#include "visu.h"
#include "vec.h"
#include "img.h"



// stocke une couleur dans l'image
void colorf(IMG *img, int x, int y, float r, float g, float b)
{
	PIX c;
	
	c= color_clamp(r * 255.);
	img->data[3*(y*img->largeur + x)   ]= c;
	
	c= color_clamp(g * 255.);
	img->data[3*(y*img->largeur + x) +1]= c;
	
	c= color_clamp(b * 255.);
	img->data[3*(y*img->largeur + x) +2]= c;
}

IMG *visu(CSG *scene, LISTE_SOURCE *sources, CAMERA *camera)
{
	IMG *img= new_img_data24(camera->largeur, camera->hauteur);
	
	float origine[3], direction[3];
	float couleur[3];

	int x, y;
	int code;
	
	clock_t start, stop;
	
	start= clock();
	for(y= 0; y<camera->hauteur; y++)
	{
		for(x= 0; x<camera->largeur; x++)
		{
			// generer un rayon  pour le pixel (x, y)
			camera_rayon(camera, (float) x, (float) y, origine, direction);
			
			// determiner quel est l'objet visible == intersection du rayon et de la scene
			code= rayon_whitted_opaque(scene, sources, origine, direction, couleur, 0);

			colorf(img, x, y, couleur[0], couleur[1], couleur[2]);
		}

		printf("line %d/%d    \r", y, camera->hauteur);
		fflush(stdout);
	}
	
	stop= clock();
	printf("\n%g secondes\n", (float) (stop - start) / (float) CLOCKS_PER_SEC);
	
	return img;
}

