/*
	squelette de visualisation a completer
	
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <time.h>

#include "struct.h"
#include "camera.h"
#include "source.h"
#include "visu.h"
#include "vec.h"
#include "img.h"


// stocke une couleur dans l'image
void colorf(IMG *img, int x, int y, float r, float g, float b)
{
	PIX c;
	
	c= color_clamp(r * 255.);
	img->data[3*(y*img->largeur + x)   ]= c;
	
	c= color_clamp(g * 255.);
	img->data[3*(y*img->largeur + x) +1]= c;
	
	c= color_clamp(b * 255.);
	img->data[3*(y*img->largeur + x) +2]= c;
}


IMG *visu(CSG *scene, LISTE_SOURCE *sources, CAMERA *camera)
{
	IMG *img= new_img_data24(camera->largeur, camera->hauteur);
	
	float origine[3], direction[3];
	float couleur[3], chemin_couleur[3];

	float xf, yf, kf;
	int x, y, k;
	int code;
	
	clock_t start, stop;
	
	start= clock();

	for(y= 0; y<camera->hauteur; y++)
	{
		for(x= 0; x<camera->largeur; x++)
		{
			vec3_zero(couleur);
			for(k= 0; k < CHEMIN_ECHANTILLONS_N; k++)
			{
				// generer un rayon uniforme dans le pixel (x, y)
				xf= (float) x + (float) rand() / (float) RAND_MAX;
				yf= (float) y + (float) rand() / (float) RAND_MAX;
				
				camera_rayon(camera, xf, yf, origine, direction);
				
				// lancer le rayon et calculer la couleur incidente
				rayon_chemin_opaque(scene, sources, origine, direction, chemin_couleur, 0);
				vec3_add(couleur, couleur, chemin_couleur);
			}
			
			// 
			kf= 1. / (float) k;
			vec3_const_mul(couleur, kf, couleur);
			colorf(img, x, y, couleur[0], couleur[1], couleur[2]);
		}

		stop= clock();
		printf("%d/%d   temps ecoule %d secondes, temps estime %d secondes          \r", y, camera->hauteur, 
			(int) ((float) (stop - start) / (float) CLOCKS_PER_SEC + .5), 
			(int) ((float) camera->hauteur / (float) (y + 1) * (float) (stop - start) / (float) CLOCKS_PER_SEC + .5));
		fflush(stdout);
	}
	
	stop= clock();
	
	printf("\n%g secondes\n", (float) (stop - start) / (float) CLOCKS_PER_SEC);
	
	return img;
}

