#ifndef _IMG_H
#define _IMG_H

typedef unsigned char PIX;

typedef struct _img
{
	int largeur;
	int hauteur;
	int alignement;
	
	int palette_n;
	PIX *palette;

	PIX *data;
} IMG;

#define LO(a) (unsigned char) ((a) & 0xFF)
#define HI(a) (unsigned char) ((a)>>8 & 0xFF)

#define int_HIHI(a) (unsigned char) ((a)>>24 & 0xFF)
#define int_HILO(a) (unsigned char) ((a)>>16 & 0xFF)
#define int_LOHI(a) (unsigned char) ((a)>>8 & 0xFF)
#define int_LOLO(a) (unsigned char) ((a) & 0xFF)

#define LOHI(l, h) (((int)(h)<<8) + (int)(l))
#define LOHI_int(ll, lh, hl, hh) (((int)(hh)<<24) + ((int)(hl)<<16) + ((int)(lh)<<8) + (int)(ll))

extern PIX color_clamp(float c);
extern IMG *new_img_data24(int w, int h);
extern IMG *new_img_palette256(int w, int h);
extern IMG *new_img_nodata(int w, int h);
extern void free_img(IMG *img);
extern void clear_img(IMG *img);

extern void img_palette(IMG *img, int i, int r, int g, int b, int a);
extern IMG *img_256_rgb(IMG *in);


#endif
