/*
	definition d'un arbre de construction

	mailto:jciehl@bat710.univ-lyon1.fr
	mars 2004
 */

#ifndef _STRUCT_H
#define _STRUCT_H

#define EPSILON 0.00001

#ifndef __GNUC__
#define M_PI 3.141592654
#endif

// representation d'une matiere
typedef struct
{
	float k_du;
	float k_dd;
	float dd_n;
	float k_sp;

	float n;
	float a;
} MATIERE;


// representation d'une intersection
typedef struct _inter
{
	float t;
	float n[3];

	float r, g, b;
	MATIERE *matiere;
} INTER;

// tableau dynamique pour stocker un ensemble de couples d'intersections (point d'entree [0] + point de sortie [1])
typedef struct _liste_inter
{
	struct _inter (*data)[2];
	int size;
	int n;
} LISTE_INTER;

enum {inter_entree= 0, inter_sortie= 1};


// representation d'une sphere
typedef struct
{
	float centre[3];
	float rayon;
} PRIM_SPHERE;

// representation d'un plan / demi-espace
typedef struct
{
	float point[3];
	float normale[3];
} PRIM_PLAN;

// representation generale d'une primitive
typedef struct _prim
{
	int type;

	float r, g, b;
	MATIERE *matiere;

	int (*intersection)(struct _prim *p, struct _liste_inter *inter, float origine[4], float direction[4]);
	void *donnees;
} PRIM;

enum {primitive_sphere= 1, primitive_plan};


struct _csg;

// representation d'une operation booleenne
typedef struct _opcsg
{
	int type;

	int (*intersection)(struct _opcsg *p, struct _liste_inter *inter, float origine[4], float direction[4]);

	struct _csg *op;
	int op_size;
	int op_n;
} OPCSG;

enum {bool_union= 1, bool_intersection, bool_differenceA, bool_differenceB};


// representation d'un noeud de l'arbre csg
typedef struct _csg
{
	int type;

	union
	{
		PRIM *primitive;
		OPCSG *operation;
	} noeud;
} CSG;

enum {csg_bool= 1, csg_primitive};


// representation de la camera
typedef struct
{
	float E[3];
	float U[3], V[3], W[3];

	float u, v;
	int largeur, hauteur;
} CAMERA;


// source ponctuelle, pour commencer ...
typedef struct
{
	float p[3];
} SOURCE_POINT;

// source spherique, pour mieux faire ...
typedef struct
{
	float p[3];
	float r;
} SOURCE_SPHERE;


// source generique
typedef struct _source
{
	int type;

	void (*rayon_ombre)(struct _source *src, float point[3], float direction[3], float *poids);

	float r, g, b;
	float ar, ag, ab;	// energie ambiante de la source

	float energie;
	float aire;

	void *donnees;
} SOURCE;

enum {src_point= 1, src_sphere};


// ensemble de sources
typedef struct
{
	SOURCE *data;
	int size;
	int n;
} LISTE_SOURCE;


// prototypes des fonctions de struct.c
extern float radians(float d);
extern void array_add(void **parray, int *size, int n, int e_size, int e_more);

extern void liste_inter_add(LISTE_INTER *liste, INTER *entree, INTER *sortie);

extern void liste_source_add(LISTE_SOURCE *liste, SOURCE *source);

#endif
