/*
	source de lumieres
	
	mailto:jciehl@bat710.univ-lyon1.fr
	mars 2004
 */

#include <stdlib.h>
#include <assert.h>

#include "struct.h"
#include "vec.h"


// source ponctuelle

// rayon d'ombre entre p et la source (non norme)
void source_point_rayon(SOURCE *src, float p[3], float direction[3], float *poids)
{
	SOURCE_POINT *donnees= (SOURCE_POINT *) src->donnees;

	//
	assert(donnees!=NULL);
	
	//
	vec3_sub(direction, donnees->p, p);
	*poids= 1.;
}
 
SOURCE *source_point(float p[3], float r, float g, float b, float a)
{
	SOURCE *src;
	SOURCE_POINT *donnees;

	src= (SOURCE *) malloc(sizeof(SOURCE));
	assert(src!=NULL);
	
	donnees= (SOURCE_POINT *) malloc(sizeof(SOURCE_POINT));	
	assert(donnees!=NULL);
	
	vec3_copy(donnees->p, p);

	src->type= src_point;
	src->donnees= donnees;
	src->rayon_ombre= source_point_rayon;
	src->energie= (r + g + b) / 3.;
	src->aire= EPSILON;
	
	src->r= r;
	src->g= g;
	src->b= b;

	src->ar= a * r;
	src->ag= a * g;
	src->ab= a * b;
	
	return src;
}


// source spherique

// rayon d'ombre entre p et la source (non norme)
void source_sphere_rayon(SOURCE *src, float p[3], float direction[3], float *poids)
{
	float q[3];
	float r2;
	SOURCE_SPHERE *donnees= (SOURCE_SPHERE *) src->donnees;
	
	//
	assert(donnees!=NULL);
	
	// ne fonctionne correctement que si aucun objet n'intersecte la sphere
	do
	{
		// genere un point uniforme dans un cube
		q[0]= (float) rand() * donnees->r*2. / (float) RAND_MAX - donnees->r;
		q[1]= (float) rand() * donnees->r*2. / (float) RAND_MAX - donnees->r;
		q[2]= (float) rand() * donnees->r*2. / (float) RAND_MAX - donnees->r;

		r2= vec3_length2(q);
	}
	while(r2 > donnees->r*donnees->r);
	// tirage par rejet pour obtenir un point dans la sphere de rayon r

	// repere global
	vec3_add(q, donnees->p, q);
	vec3_sub(direction, q, p);
	
	*poids= 1.;
}
 
SOURCE *source_sphere(float p[3], float rayon, float r, float g, float b, float a)
{
	SOURCE *src;
	SOURCE_SPHERE *donnees;

	src= (SOURCE *) malloc(sizeof(SOURCE));
	assert(src!=NULL);
	
	donnees= (SOURCE_SPHERE *) malloc(sizeof(SOURCE_SPHERE));
	assert(donnees!=NULL);
	
	vec3_copy(donnees->p, p);
	donnees->r= rayon;

	src->type= src_sphere;
	src->donnees= donnees;
	src->rayon_ombre= source_sphere_rayon;
	src->energie= (r + g + b) / 3.;
	src->aire= 4. * M_PI * rayon*rayon;
	
	src->r= r;
	src->g= g;
	src->b= b;

	src->ar= a * r;
	src->ag= a * g;
	src->ab= a * b;
	
	return src;
}

