/*
	operations booleennes sur un arbre de construction

	fonctions d'intersection a completer
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "struct.h"

// fonction utilitaire
OPCSG *op_csg(int type, int (*intersection)(struct _opcsg *p, struct _liste_inter *inter, float origine[4], float direction[4]))
{
	OPCSG *p= (OPCSG *) malloc(sizeof(OPCSG));
	assert(p!=NULL);

	p->type= type;
	p->intersection= intersection;

	p->op= NULL;
	p->op_size= 0;
	p->op_n= 0;

	return p;
}




// union de n operandes
int union_intersection(OPCSG *op, LISTE_INTER *inter, float origine[4], float direction[4])
{
	LISTE_INTER *inter_op;
	void **inter_op_free;
	int *inter_k;
	INTER *entree, *sortie;
	int inter_next;
	int inter_n;
	int inter_op_free_n;
	int i;
	int code;

	// preparer les listes d'intersections pour chaque operande
	inter_op= (LISTE_INTER *) malloc(sizeof(LISTE_INTER) * op->op_n);
	assert(inter_op!=NULL);
	
	inter_op_free_n= 0;
	inter_op_free= (void **) malloc(sizeof(void *) * op->op_n);
	assert(inter_op_free!=NULL);
	
	inter_k= (int *) malloc(sizeof(int) * op->op_n);
	assert(inter_k!=NULL);
	
	// calculer les intersections pour chaque operande
	inter_n= 0;
	for(i= 0; i<op->op_n; i++)
	{
		inter_op_free[i]= NULL;
		
		inter_op[i].data= NULL;
		inter_op[i].size= 0;
		inter_op[i].n= 0;
		
		inter_k[i]= 0;

		code= 0;
		if(op->op[i].type==csg_primitive)
			code= op->op[i].noeud.primitive->intersection(op->op[i].noeud.primitive, &inter_op[inter_n], origine, direction);
	
		else if(op->op[i].type==csg_bool)
			code= op->op[i].noeud.operation->intersection(op->op[i].noeud.operation, &inter_op[inter_n], origine, direction);
		
		if(code > 0)
		{
			// printf("[%f .. %f],  ", inter_op[inter_n].data[0][inter_entree].t, inter_op[inter_n].data[0][inter_sortie].t);
			inter_n++;
		}
	}

	// determiner l'union des operandes
	while(inter_n > 0)
	{
		// . trouver le premier intervalle
		entree= &inter_op[0].data[inter_k[0]][inter_entree];
		sortie= &inter_op[0].data[inter_k[0]][inter_sortie];
		inter_next= 0;
		
		for(i= 1; i<inter_n; i++)
		{
			if(inter_op[i].data[inter_k[i]][inter_entree].t < entree->t)
			{
				entree= &inter_op[i].data[inter_k[i]][inter_entree];
				sortie= &inter_op[i].data[inter_k[i]][inter_sortie];
				inter_next= i;
			}
		}

		inter_k[inter_next]++;
		if(inter_k[inter_next] >= inter_op[inter_next].n)
		{
			// supprimer la liste
			inter_op_free[inter_op_free_n++]= inter_op[inter_next].data;
			
			inter_n--;
			inter_op[inter_next]= inter_op[inter_n];
			inter_k[inter_next]= inter_k[inter_n];
		}
		
		// . fusion des intervalles
		do
		{
			inter_next= -1;
			for(i= 0; i<inter_n; i++)
			{
				if(inter_op[i].data[inter_k[i]][inter_entree].t < sortie->t)
				{
					if(inter_op[i].data[inter_k[i]][inter_sortie].t > sortie->t)
						sortie= &inter_op[i].data[inter_k[i]][inter_sortie];
					
					inter_k[i]++;

					inter_next= i;
					if(inter_k[inter_next] >= inter_op[inter_next].n)
					{
						// supprimer la liste
						inter_op_free[inter_op_free_n++]= inter_op[inter_next].data;
						
						inter_n--;
						inter_op[inter_next]= inter_op[inter_n];
						inter_k[inter_next]= inter_k[inter_n];
					}
					break;
				}
			}
		}
		while(inter_next!=-1);

		// printf("== [%f .. %f]\n", entree->t, sortie->t);
		liste_inter_add(inter, entree, sortie);
	}
	
	//
	for(i= 0; i<inter_op_free_n; i++)
		if(inter_op_free[i]!=NULL)
			free(inter_op_free[i]);
	
	free(inter_op_free);
	free(inter_op);
	free(inter_k);	
	
	return (inter->n > 0) ? 1 : 0;
}

OPCSG *op_union(void)
{
	return op_csg(bool_union, union_intersection);
}



int intersection_intersection(OPCSG *op, LISTE_INTER *inter, float origine[4], float direction[4])
{
	LISTE_INTER *inter_op;
	int *inter_k;
	INTER *entree, *sortie;
	int inter_next;
	int inter_n;
	int i;
	int code;

	// preparer les listes d'intersections pour chaque operande
	inter_op= (LISTE_INTER *) malloc(sizeof(LISTE_INTER) * op->op_n);
	assert(inter_op!=NULL);
	
	inter_k= (int *) malloc(sizeof(int) * op->op_n);
	assert(inter_k!=NULL);
	
	// calculer les intersections pour chaque operande
	inter_n= 0;
	for(i= 0; i<op->op_n; i++)
	{
		inter_op[i].data= NULL;
		inter_op[i].size= 0;
		inter_op[i].n= 0;
		
		inter_k[i]= 0;

		code= 0;
		if(op->op[i].type==csg_primitive)
			code= op->op[i].noeud.primitive->intersection(op->op[i].noeud.primitive, &inter_op[i], origine, direction);
	
		else if(op->op[i].type==csg_bool)
			code= op->op[i].noeud.operation->intersection(op->op[i].noeud.operation, &inter_op[i], origine, direction);
		
		if(code > 0)
			inter_n++;
	}

	// determiner l'intersection des operandes
	if(inter_n==op->op_n)
	{
		entree= &inter_op[0].data[inter_k[0]][inter_entree];
		sortie= &inter_op[0].data[inter_k[0]][inter_sortie];
		inter_next= 0;

		while(inter_k[inter_next] < inter_op[inter_next].n)
		{
			for(i= 0; i<op->op_n; i++)
			{
				if(inter_op[i].data[inter_k[i]][inter_entree].t > entree->t)
					entree= &inter_op[i].data[inter_k[i]][inter_entree];

				if(inter_op[i].data[inter_k[i]][inter_sortie].t < sortie->t)
				{
					sortie= &inter_op[i].data[inter_k[i]][inter_sortie];
					inter_next= i;
				}
			}	

			if(entree->t < sortie->t)
				liste_inter_add(inter, entree, sortie);
			
			inter_k[inter_next]++;
		}
	}
	
	//
	for(i= 0; i<op->op_n; i++)
		if(inter_op[i].data!=NULL)
			free(inter_op[i].data);
	
	free(inter_op);
	free(inter_k);
	
	return (inter->n > 0) ? 1 : 0;
}

OPCSG *op_intersection(void)
{
	return op_csg(bool_intersection, intersection_intersection);
}

// a completer
int differenceA_intersection(struct _opcsg *p, struct _liste_inter *inter, float origine[4], float direction[4])
{
	return 0;
}

OPCSG *op_differenceA(void)
{
	return op_csg(bool_differenceA, differenceA_intersection);
}

// a completer
int differenceB_intersection(struct _opcsg *p, struct _liste_inter *inter, float origine[4], float direction[4])
{
	return 0;
}

OPCSG *op_differenceB(void)
{
	return op_csg(bool_differenceB, differenceB_intersection);
}


// creer un noeud csg pour une operation booleenne
CSG *operation(OPCSG *op)
{
	CSG *csg= (CSG *) malloc(sizeof(CSG));
	assert(csg);

	csg->type= csg_bool;
	csg->noeud.operation= op;

	return csg;
}

// ajouter une operande (un noeud de l'arbre csg) a une operation csg
void op_add(OPCSG *p, CSG *e) 
{
	array_add((void **) &p->op, &p->op_size, p->op_n, sizeof(CSG), 2);

	p->op[p->op_n++]= *e;
}

