/*
	lancer de rayons recursif
	
	matieres opaques
 */

#include <stdlib.h>

#include "struct.h"
#include "source.h"
#include "visu.h"
#include "matiere.h"
#include "vec.h"


// calcule l'eclairement direct en un point
void whitted_eclairement_direct(CSG *scene, LISTE_SOURCE *sources, INTER *inter, float point[3], float direction[3], float couleur[3])
{
	LISTE_INTER inter_ombre;
	
	float v[3], v_refl[3], n[3];
	float source_couleur[3];
	float ombre_direction[3];
	float ombre_poids;
	float r;
	
	int code;
	int s, i;
	int rayons_n;

	/* a completer
	 */
	
	if(inter_ombre.data!=NULL)
		free(inter_ombre.data);
}



// lancer de rayon recursif sur objets opaques
// profondeur limitee
int rayon_whitted_opaque(CSG *scene, LISTE_SOURCE *sources, float origine[3], float direction[3], float couleur[3], int profondeur)
{
	LISTE_INTER inter;

	float miroir_couleur[3];
	float v_refl[3];
	float p[3];
	float n[3];
	float r;
	
	int code;

	//	
	couleur[0]= 0.; couleur[1]= 0.; couleur[2]= 0.;
	if(profondeur > WHITTED_PROFONDEUR)
		return 0;
	
	//
	inter.data= NULL;
	inter.n= 0;
	inter.size= 0;
	
	// determiner quel est l'objet visible == intersection du rayon et de la scene
	code= 0;
	if(scene->type==csg_primitive)
		code= scene->noeud.primitive->intersection(scene->noeud.primitive, &inter, origine, direction);
	else if(scene->type==csg_bool)
		code= scene->noeud.operation->intersection(scene->noeud.operation, &inter, origine, direction);

	if(code>0 && inter.data[0][inter_entree].t > 0.)
	{
		// calculer la position du point d'intersection
		vec3_add_mul_const(p, origine, inter.data[0][inter_entree].t, direction);

		// recuperer la normale au point d'intersection 
		vec3_copy(n, inter.data[0][inter_entree].n);

		// decaler le point d'intersection le long de la normale
		vec3_add_mul_const(p, p, EPSILON, n);

		/// calcul de l'eclairement direct
		whitted_eclairement_direct(scene, sources, &inter.data[0][inter_entree], p, direction, couleur);
	
		// detecter les matieres qui necessitent de lancer des rayons supplementaires (miroir, objets transparents ...)
		if(inter.data[0][inter_entree].matiere->k_sp > EPSILON)
		{
			/* a completer 
			 */
			
			// generer la direction reflechie 

			// lancer un rayon supplementaire, couleur resultat dans 'miroir_couleur'

			// ajouter la couleur
			r= inter.data[0][inter_entree].matiere->k_sp + (1. - inter.data[0][inter_entree].matiere->k_sp) * pow(1. + vec3_dot(n, direction), 5.);
			vec3_add_mul_const(couleur, couleur, r, miroir_couleur);
		}
	}

	if(inter.data!=NULL)
		free(inter.data);
	
	return 1;
}

