#ifndef _MATIERE_H
#define _MATIERE_H

#include "struct.h"

extern MATIERE *matiere(float du, float dd, float dd_n, float sp, float n, float a);
extern MATIERE *matiere_diffus(float du);
extern MATIERE *matiere_diffus_directionnel(float du, float dd, float dd_n);
extern MATIERE *matiere_speculaire(float dd, float dd_n, float sp);
extern MATIERE *matiere_miroir(float sp);
extern MATIERE *matiere_transparent(float n, float a);

// calcul des directions particulieres 
extern void miroir_rayon(MATIERE *matiere, float direction[3], float normale[3], float v[3]);

extern void matiere_rayon(MATIERE *matiere, float normale[3], float v_refl[3], float *poids);

//
extern float matiere_brdf(MATIERE *matiere, float direction[3], float normale[3], float v[3]);

//
extern void repere_local(float u[3], float v[3], float w[3], float normale[3]);
extern void repere_local_vers_global(float u[3], float v[3], float w[3], float local[3], float global[3]);


#endif
