/*
	visualisation d'un arbre de construction

	mailto:jciehl@bat710.univ-lyon1.fr
	mars 2004
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>

#include "struct.h"
#include "primitive.h"
#include "operation.h"
#include "camera.h"
#include "source.h"
#include "matiere.h"
#include "visu.h"

#include "vec.h"
#include "img.h"
#include "tga.h"
#include "bmp.h"

// construction de la scene
CSG *scene(void)
{
	float p[3], n[3];
	PRIM *pr;
	CSG *csg, *root;

	// racine
	root= operation(op_union());

#if 1
	// un plan 
	p[0]= -1.;
	p[1]= -1.;
	p[2]= 0.;

	n[0]= 1.;
	n[1]= 1.;
	n[2]= 0.;
	pr= plan(.6, .0 , .0,  p, n);
	primitive_matiere(pr, matiere_diffus(.8));
	op_add(root->noeud.operation, primitive(pr));
#endif

	csg= operation(op_union());
	op_add(root->noeud.operation, csg);

	// une sphere
	p[0]=  1.;
	p[1]=  1.;
	p[2]= -3.;
	pr= sphere(.9, .9 , .9,  p, 1.);
	primitive_matiere(pr, matiere_diffus(1.));
	op_add(csg->noeud.operation, primitive(pr));

	// une sphere
	p[0]=  1.;
	p[1]= -.5;
	p[2]= -3.5;
	pr= sphere(.9, .9 , .9,  p, 1.2);
	primitive_matiere(pr, matiere_diffus(.8));
	// primitive_matiere(pr, matiere_miroir(.8));
	op_add(csg->noeud.operation, primitive(pr));


	// une sphere miroir
	p[0]=  -1.;
	p[1]= -.5;
	p[2]= -5.;
	pr= sphere(1., 1. , 1.,  p, 1.);
	primitive_matiere(pr, matiere_miroir(.8));
	op_add(csg->noeud.operation, primitive(pr));

	return root;
}


int main(void)
{
	IMG *img;
	CSG *csg;
	CAMERA *obs;
	LISTE_SOURCE sources;
	SOURCE *s;
	float p[3];

	// construction de la scene
	csg= scene();

	// construction de la camera
	obs= camera_locale(60., 400, 400);

	// creation de la liste de sources de lumiere
	sources.data= NULL;
	sources.size= 0;
	sources.n= 0;


	p[0]= 10.;
	p[1]= 10.;
	p[2]= -4.;
	s= source_sphere(p, .2, 1., 1., 1., .2);	// + facteur energie ambiante
	liste_source_add(&sources, s);
	free(s);

	p[0]= 0.;
	p[1]= 10.;
	p[2]= -4.;
	s= source_sphere(p, .2, 1., 1., 1., .2);	// + facteur energie ambiante
	liste_source_add(&sources, s);
	free(s);

	// calcul
	img= visu(csg, &sources, obs);
	// img= visu(csg, NULL, obs);

	// sauver l'image
#ifdef _WIN32
	ecrire_bmp("visu.bmp", img);
#else
	ecrire_tga("visu.tga", img);
#endif

	//
	free_img(img);

	return 0;
}

