/*
	visualisation d'un arbre de construction

	mailto:jciehl@bat710.univ-lyon1.fr
	mars 2004
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>

#include "struct.h"
#include "primitive.h"
#include "operation.h"
#include "camera.h"
#include "source.h"
#include "visu.h"

#include "vec.h"
#include "img.h"
#include "tga.h"
#include "bmp.h"

// construction de la scene
CSG *scene(void)
{
// a completer ...

	// test: union de 2 spheres
	float p[3], n[3];
	PRIM *pr;
	CSG *csg;

#if 1
	// racine
	csg= operation(op_union());



#if 0
	// une sphere rouge
	p[0]= 0.;
	p[1]= -100.;
	p[2]= -10.;
	pr= sphere(1., 0. , 0.,  p, 100.);
	op_add(csg->noeud.operation, primitive(pr));

#else
	// un plan rouge
	p[0]= -1.;
	p[1]= -1.;
	p[2]= 0.;
	
	n[0]= 1.;
	n[1]= 1.;
	n[2]= 0.;
	pr= plan(.8, 0. , 0.,  p, n);
	op_add(csg->noeud.operation, primitive(pr));
#endif

#if 1
	// une sphere bleue
	p[0]=  1.;
	p[1]=  1.;
	p[2]= -3.;
	pr= sphere(0., 0. , 1.,  p, 1.);
	op_add(csg->noeud.operation, primitive(pr));
#endif

#if 1
	// une sphere verte
	p[0]=  1.;
	p[1]= -.5;
	p[2]= -3.5;
	pr= sphere(0., 1. , 0.,  p, 1.2);
	op_add(csg->noeud.operation, primitive(pr));
#endif

#else
	// csg= operation(op_union());

	// une sphere rouge
	p[0]= -1.;
	p[1]= -1.;
	p[2]= -5.;
	pr= sphere(1., 0. , 0.,  p, 3);
	// op_add(csg->noeud.operation, primitive(sp));
	csg= primitive(pr);
#endif

	return csg;
}

CSG *scene_bool_inter(void)
{
	float p[3];
	PRIM *sp;
	CSG *root;
	CSG *csg;
	
	root= operation(op_intersection());

	// une sphere rouge
	p[0]= -1.;
	p[1]= -1.;
	p[2]= -5.;
	sp= sphere(1., 0. , 0.,  p, 2.);
	op_add(root->noeud.operation, primitive(sp));
	
	csg= operation(op_union());
	op_add(root->noeud.operation, csg);
	
	// une sphere verte
	p[0]=  1.;
	p[1]= -1.;
	p[2]= -5.;
	sp= sphere(0., 1. , 0.,  p, 1.);
	op_add(csg->noeud.operation, primitive(sp));

	// une sphere bleue
	p[0]=  0.;
	p[1]= -1.;
	p[2]= -7.;
	sp= sphere(0., 0. , 1.,  p, 1.);
	op_add(csg->noeud.operation, primitive(sp));
	
	return root;
}

int main(void)
{
	IMG *img;
	CSG *csg;
	CAMERA *obs;
	LISTE_SOURCE sources;
	SOURCE *s;
	float p[3];

	// construction de la scene
	csg= scene();
	// csg= scene_bool_inter();

	// construction de la camera
	obs= camera_locale(60., 600, 600);

	// creation de la liste de sources de lumiere
	sources.data= NULL;
	sources.size= 0;
	sources.n= 0;
	
	p[0]= 10.;
	p[1]= 10.;
	p[2]= -4.;
	s= source(p, .7, .7, .7, .2);	// + facteur energie ambiante
	liste_source_add(&sources, s);
	free(s);

#if 1
	p[0]= 6.;
	p[1]= 10.;
	p[2]= -5.;
	s= source(p, .5, .5, .5, .2);	// + facteur energie ambiante
	liste_source_add(&sources, s);
	free(s);
#endif

	// calcul
	img= visu(csg, &sources, obs);
	// img= visu(csg, NULL, obs);

	// sauver l'image
#ifdef _WIN32
	ecrire_bmp("visu.bmp", img);
#else
	ecrire_tga("visu.tga", img);
#endif
	
	//
	free_img(img);

	return 0;
}

