/*
	squelette de visualisation a completer
	
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <time.h>

#include "struct.h"
#include "camera.h"
#include "source.h"
#include "vec.h"
#include "img.h"

// stocke une couleur dans l'image
void colorf(IMG *img, int x, int y, float r, float g, float b)
{
	PIX c;
	
	c= color_clamp(r * 255.);
	img->data[3*(y*img->largeur + x)   ]= c;
	
	c= color_clamp(g * 255.);
	img->data[3*(y*img->largeur + x) +1]= c;
	
	c= color_clamp(b * 255.);
	img->data[3*(y*img->largeur + x) +2]= c;
}

// a completer
IMG *visu(CSG *scene, LISTE_SOURCE *sources, CAMERA *camera)
{
	LISTE_INTER inter, inter_ombre;
	IMG *img= new_img_data24(camera->largeur, camera->hauteur);
	
	float origine[3], direction[3];
	float ombre_origine[3], ombre_direction[3];
	float l[3];
	float p[3];
	float n[3];
	float du;
	float r, g, b;

	int x, y;
	int s;
	int code;
	
	clock_t start, stop;
	
	start= clock();

	inter.data= NULL;
	inter.n= 0;
	inter.size= 0;
	
	inter_ombre.data= NULL;
	inter_ombre.n= 0;
	inter_ombre.size= 0;
	
	for(y= 0; y<camera->hauteur; y++)
	{
		for(x= 0; x<camera->largeur; x++)
		{
			// generer un rayon  pour le pixel (x, y)
			camera_rayon(camera, (float) x, (float) y, origine, direction);
			
			// determiner quel est l'objet visible == intersection du rayon et de la scene
			inter.n= 0;
			code= 0;
			if(scene->type==csg_primitive)
				code= scene->noeud.primitive->intersection(scene->noeud.primitive, &inter, origine, direction);
			else if(scene->type==csg_bool)
				code= scene->noeud.operation->intersection(scene->noeud.operation, &inter, origine, direction);

			r= 0.; g= 0.; b= 0.;
			if(code>0 && inter.data[0][inter_entree].t > 0.)
			{
				// a completer
			}
			
			colorf(img, x, y, r, g, b);
		}

		// printf("line %d/%d    \r", y, camera->hauteur);
		// fflush(stdout);
	}
	
	stop= clock();
	
	printf("\n%g secondes\n", (float) (stop - start) / (float) CLOCKS_PER_SEC);
	
	//
	if(inter.data!=NULL)
		free(inter.data);
	
	if(inter_ombre.data!=NULL)
		free(inter_ombre.data);
	
	return img;
}

