/*
	source de lumieres
	
	mailto:jciehl@bat710.univ-lyon1.fr
	mars 2004
 */

#include <stdlib.h>
#include <assert.h>

#include "struct.h"
#include "vec.h"

//
SOURCE *source(float p[3], float r, float g, float b, float a)
{
	SOURCE *src= (SOURCE *) malloc(sizeof(SOURCE));
	assert(src!=NULL);
	
	vec3_copy(src->p, p);
	src->r= r;
	src->g= g;
	src->b= b;

	src->ar= a * r;
	src->ag= a * g;
	src->ab= a * b;
	
	return src;
}

// rayon d'ombre entre p et la source (non norme)
void source_rayon(SOURCE *src, float p[3], float origine[3], float direction[3])
{
	vec3_sub(direction, src->p, p);
	vec3_copy(origine, src->p);
}
 
