/*
	primitives elementaires
	
	fonctions d'intersection a completer
 */

#include <stdlib.h>
#include <assert.h>
#include <math.h>

#include "struct.h"
#include "vec.h"

// a completer
int sphere_intersection(PRIM *p, LISTE_INTER *inter, float origine[4], float direction[4])
{
	INTER entree, sortie;
	float oc[3], q[3];
	float A, B, C, det;
	PRIM_SPHERE *donnees= (PRIM_SPHERE *) p->donnees;
	assert(donnees!=NULL);

	A= vec3_dot(direction, direction);
	
	vec3_sub(oc, origine, donnees->centre);
	B= 2. * vec3_dot(direction, oc);
	
	C= vec3_dot(oc, oc) - donnees->rayon*donnees->rayon;
	
	det= B*B - 4.*A*C;
	if(det >= EPSILON)
	{
		det= sqrt(det);

		entree.t= (-B - det) / (2.*A);
		
		vec3_add_mul_const(q, origine, entree.t, direction);
		vec3_sub(entree.n, q, donnees->centre);
		vec3_norm(entree.n, entree.n);
		
		entree.r= p->r;
		entree.g= p->g;
		entree.b= p->b;
	
		sortie.t= (-B + det) / (2.*A);
		
		vec3_add_mul_const(q, origine, sortie.t, direction);
		vec3_sub(sortie.n, q, donnees->centre);
		vec3_norm(sortie.n, sortie.n);
		
		sortie.r= p->r;
		sortie.g= p->g;
		sortie.b= p->b;

		// verifie que l'intersection est valide ... devant la camera t > 0
		// elimine aussi la primitve lorsque la camera se trouve a l'interieur
		if(entree.t > EPSILON)
		{
			// printf("%f %f %f (%f) == %f .. %f\n", donnees->centre[0], donnees->centre[1], donnees->centre[2], donnees->rayon, entree.t, sortie.t);
			liste_inter_add(inter, &entree, &sortie);
			return 1;
		}
		else
			// printf("-- %f %f %f (%f) == %f .. %f\n", donnees->centre[0], donnees->centre[1], donnees->centre[2], donnees->rayon, entree.t, sortie.t);
			{;}
	}
	
	return 0;
}

PRIM *sphere(float r, float g, float b, float centre[3], float rayon)
{
	PRIM *p;
	PRIM_SPHERE *donnees;
	
	p= (PRIM *) malloc(sizeof(PRIM));
	assert(p!=NULL);
	
	donnees= (PRIM_SPHERE *) malloc(sizeof(PRIM_SPHERE));
	assert(donnees!=NULL);

	p->type= primitive_sphere;
	p->intersection= sphere_intersection;
	p->r= r;
	p->g= g;
	p->b= b;
	
	p->donnees= donnees;
	
	vec3_copy(donnees->centre, centre);
	donnees->rayon= rayon;
	
	return p;
}


// a completer
int plan_intersection(PRIM *p, LISTE_INTER *inter, float origine[4], float direction[4])
{
	INTER entree, sortie;
	float op[3];
	float t;
	PRIM_PLAN *donnees= (PRIM_PLAN *) p->donnees;
	assert(donnees!=NULL);

	vec3_sub(op, donnees->point, origine);
	t= vec3_dot(op, donnees->normale) / vec3_dot(direction, donnees->normale);
	
	if(t > EPSILON)
	{
		entree.t= t;
		vec3_copy(entree.n, donnees->normale);
		entree.r= p->r;
		entree.g= p->g;
		entree.b= p->b;
		// printf("[%f .. inf]\n", t);

		sortie.t= HUGE_VAL;
		vec3_neg(sortie.n, donnees->normale);
		sortie.r= p->r;
		sortie.g= p->g;
		sortie.b= p->b;

		liste_inter_add(inter, &entree, &sortie);
		return 1;
	}
	
	return 0;
}

PRIM *plan(float r, float g, float b, float q[3], float n[3])
{
	PRIM *p;
	PRIM_PLAN *donnees;
	
	p= (PRIM *) malloc(sizeof(PRIM));
	assert(p!=NULL);
	
	donnees= (PRIM_PLAN *) malloc(sizeof(PRIM_PLAN));
	assert(donnees!=NULL);

	p->type= primitive_plan;
	p->intersection= plan_intersection;
	p->r= r;
	p->g= g;
	p->b= b;

	p->donnees= donnees;
	
	vec3_norm(donnees->normale, n);
	vec3_copy(donnees->point, q);
	
	return p;
}



// creer un noeud csg pour une primitive 
CSG *primitive(PRIM *p)
{
	CSG *csg= (CSG *) malloc(sizeof(CSG));
	assert(csg);
	
	csg->type= csg_primitive;
	csg->noeud.primitive= p;
	
	return csg;
}
