/*
	quelques utilitaires
	
 */

#include <stdlib.h>
#include <assert.h>

#include "struct.h"


// conversion degres vers radians
float radians(float d)
{
	return d * 0.0174532925;
}

/* allocation tableau dynamique generique

   parray (in/out) : adresse du pointeur sur le tableau
   size (in/out)   : nombre d'elements deja reserves
   n (in)          : rang d'insertion
   e_size (in)     : taille d'un element du tableau (en octets)
   e_more (in)     : nombre d'elements supplementaires a allouer
   
   remarque: (*parray) doit etre NULL lors du premier appel
 */
void array_add(void **parray, int *size, int n, int e_size, int e_more)
{
	if(n >= *size)
	{
		// alloue un tableau de plus de n+1 elements (le rang n est donc accessible)
		*size= ((n / e_more) + 1) * e_more;
		
		*parray= realloc(*parray, *size * e_size);
		assert(*parray!=NULL);
	}
}

/*	ajouter une intersection (point d'entree dans la primitive + point de sortie) dans une liste d'intersections
	
	entree et sortie peuvent etre NULL pour indiquer que le point d'intersection n'existe pas,
	ils sont ensuite reperes par une abscisse negative (-1.0) dans la liste d'intersections
 */ 
void liste_inter_add(LISTE_INTER *liste, INTER *entree, INTER *sortie)
{
	// marqueur pour intersection non definie t==-1
	/*  struct INTER { float t; float n[3]; float r, g, b; } */
	INTER inull= {-1., {0., 0., 0.}, 0., 0., 0.}; 
	
	array_add((void **) &liste->data, &liste->size, liste->n, sizeof(INTER[2]), 2);
	
	if(entree==NULL)
		entree= &inull;

	if(sortie==NULL)
		sortie= &inull;
	
	liste->data[liste->n][inter_entree]= *entree;
	liste->data[liste->n][inter_sortie]= *sortie;
	liste->n++;
}

