/*
	visualisation d'un arbre de construction 
	
	mailto:jciehl@bat710.univ-lyon1.fr	
	mars 2004
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>

#include "struct.h"
#include "primitive.h"
#include "operation.h"
#include "camera.h"
#include "visu.h"

#include "vec.h"
#include "img.h"
#include "tga.h"


// construction de la scene
CSG *scene(void)
{
// a completer ... 

	// test: union de 2 spheres
	float p[3];
	PRIM *sp;
	CSG *csg;

	// racine
	csg= operation(op_union());
	
	// une sphere rouge
	p[0]= -1.;
	p[1]= -1.;
	p[2]= -5.;	
	sp= sphere(1., 0. , 0.,  p, 3);
	op_add(csg->noeud.operation, primitive(sp));
	
	// une sphere verte
	p[0]=  2.;
	p[1]= -1.;
	p[2]= -4.;	
	sp= sphere(0., 1. , 0.,  p, 2);
	op_add(csg->noeud.operation, primitive(sp));
	
	return csg;
}


int main(void)
{
	IMG *img;
	CSG *csg;
	CAMERA *obs;
	
	// construction de la scene
	csg= scene();
	
	// construction de la camera
	obs= camera_locale(50., 500, 500);
	
	// calcul
	img= visu(csg, obs);
	
	// sauver l'image
	ecrire_tga("visu.tga", img);
	
	//
	free_img(img);
	
	return 0;
}

