#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "img.h"

PIX color_clamp(float c)
{
	if(c < 0.f)
		return 0;
	else if(c > 255.f)
		return 255;
	else
		return (PIX) (c + .5f);
}

IMG *new_img_data24(int w, int h)
{
	IMG *img;
	
	img= (IMG *) malloc(sizeof(IMG));
	assert(img);

	img->largeur= w;
	img->hauteur= h;
	img->alignement= 3*w;

	img->palette= NULL;
	img->palette_n= 0;

	img->data= (unsigned char *) calloc(1, sizeof(unsigned char[3]) * w*h);
	assert(img->data);

	return img;
}

IMG *new_img_palette256(int w, int h)
{
	IMG *img;
	
	img= (IMG *) malloc(sizeof(IMG));
	assert(img);

	img->largeur= w;
	img->hauteur= h;
	img->alignement= w;

	img->palette= (unsigned char *) calloc(256, sizeof(unsigned char[4]));
	assert(img->palette);
	img->palette_n= 256;

	img->data= (unsigned char *) calloc(1, sizeof(unsigned char) * w*h);
	assert(img->data);

	return img;
}

// fixe une couleur de la palette d'une image 256 couleurs
void img_palette(IMG *img, int i, int r, int g, int b, int a)
{
	assert(img);
	
	if(img->palette_n > 0 && i < img->palette_n)
	{
		i= sizeof(unsigned char[4]) * i;
		img->palette[i]=   (unsigned char) r;
		img->palette[i+1]= (unsigned char) g;
		img->palette[i+2]= (unsigned char) b;
		img->palette[i+3]= (unsigned char) a;
	}
}


IMG *img_256_rgb(IMG *in)
{
	IMG *img= new_img_data24(in->largeur, in->hauteur);
	int i, p;
	int size;
	
	if(in->palette_n > 0)
	{
		size= in->largeur * in->hauteur;
		for(i= 0; i<size; i++)
		{
			img->data[3*i]=    in->palette[4*in->data[i]];
			img->data[3*i +1]= in->palette[4*in->data[i] +1];
			img->data[3*i +2]= in->palette[4*in->data[i] +2];
		}
	}
	
	return img;
}


IMG *new_img_nodata(int w, int h)
{
	IMG *img;
	
	img= (IMG *) malloc(sizeof(IMG));
	assert(img);

	img->largeur= w;
	img->hauteur= h;
	img->alignement= w;

	img->data= NULL;
	img->palette= NULL;
	img->palette_n= 0;

	return img;
}

void free_img(IMG *img)
{
	if(img)
	{
		if(img->data)
			free(img->data);
		
		if(img->palette)
			free(img->palette);
		
		free(img);
	}
}


void clear_img(IMG *img)
{
	if(img)
	{
		if(img->palette_n==0)
			memset(img->data, 0, 3*img->largeur*img->hauteur);
		else if(img->palette_n==256)
			memset(img->data, 0, img->largeur*img->hauteur);
		else
			printf("-- format non reconnu dans clear_img()\n");
	}	
}

void blit(unsigned char *src, int width, int height, int sx, int sy, int sw, int sh, unsigned char *dst)
{
	int x, y;
	
	for(y= 0; y<sh; y++)
		for(x= 0; x<sw; x++)
			dst[y*sw + x]= src[(sy+y)*width + sx+x];
}


IMG *img_blit(IMG *src, int x, int y, int w, int h)
{
	IMG *img;
	
	if(src->palette_n > 0)
	{
		img= new_img_palette256(w, h);
		
		memcpy(img->palette, src->palette, sizeof(unsigned char [4]) * 256);
		blit(src->data, src->largeur, src->hauteur, x, y, w, h, img->data);
	}
	else
	{
		img= new_img_data24(w, h);
		
		blit(src->data,    src->largeur, src->hauteur, x, y, w, h, img->data);
		blit(src->data +1, src->largeur, src->hauteur, x, y, w, h, img->data +1);
		blit(src->data +2, src->largeur, src->hauteur, x, y, w, h, img->data +2);
	}

	return img;
}

