#ifndef _BMP_H
#define _BMP_H

#include <stdio.h>
#include "img.h"

typedef struct {
   unsigned short int type;
   unsigned int size;
   unsigned short int reserved1, reserved2;
   unsigned int offset;
} BMP_HEADER; // 14B

typedef struct {
   unsigned int size;               /* Header size in bytes      */
   int width,height;                /* Width and height of image */
   unsigned short int planes;       /* Number of colour planes   */
   unsigned short int bits;         /* Bits per pixel            */
   unsigned int compression;        /* Compression type          */
   unsigned int imagesize;          /* Image size in bytes       */
   int xresolution,yresolution;     /* Pixels per meter          */
   unsigned int ncolours;           /* Number of colours         */
   unsigned int importantcolours;   /* Important colours         */
} BMP_INFO; // 40B

extern IMG *lire_bmp(char *fname);
extern int ecrire_bmp(char *fname, IMG *img);

#endif
