import sys
import os

absolute_path = os.path.dirname(__file__)
relative_path = "modules"
full_path = os.path.join(absolute_path, relative_path)
sys.path.append(full_path)

import argparse
import cv2
import numpy as np
from typing import Tuple

from networking import Buffer, TCPServerAbstraction
from encoding import Packer, PackTraits

class JpegImage(PackTraits):
    TYPE_NAME   =   'cv::Mat'
    CODE        =   'JP'
    LENGTH      =   -1
    QUALITY     =   90
    @classmethod
    def pack(cls,value: list)->str:
        encode_param = [int(cv2.IMWRITE_JPEG_QUALITY), cls.QUALITY]
        result, buffer = cv2.imencode('.jpg', value, encode_param)
        temp = [
            Packer.pack(len(buffer)),
            buffer
        ]
        return b''.join(temp)
    @classmethod
    def unpack(cls,buffer:str,index:int)->Tuple[int,list]:
        try:
            index, lg = Packer.unpack(buffer,index)
            tmp = buffer[index:(index+lg)]
            mat = cv2.imdecode(np.asarray(tmp),cv2.IMREAD_COLOR)
            return index+lg, mat
        except Exception:
            raise

size = [480, 640, 3]
frame = np.zeros(size,np.uint8)

class Server(TCPServerAbstraction):
    def __init__(self):
        super().__init__(2048)
    def clientIsConnecting(self,client):
        print('connexion d\'un client')
        self.sendTo(client,sizeBuffer)
    def start(self,args):
        self.initialize(args.interface,args.port, self.clientIsConnecting)
        self.listenToClients()
    def stop(self):
        self.finalize()

if __name__ == "__main__":
    sizeBuffer = Buffer(Packer.pack(size))
    print(sizeBuffer.displayString())
    frameBuffer = Buffer(Packer.pack(frame,'cv::Mat'))
    parser = argparse.ArgumentParser()
    parser.add_argument('-i', '--interface', action='store', default='', type=str, help='network interface to use')
    parser.add_argument('-p', '--port', action='store', default=12345, type=int, help='port on server')
    args = parser.parse_args()
    server = Server ()
    server.start(args)
    cv2.namedWindow('emitted frame')
    while True:
        if server.clients>0:
            server.broadcast(frameBuffer)
        cv2.imshow('emitted frame',frame)
        key = cv2.waitKey(500) & 0x0FF
        if key == ord('x'): break
        color = np.random.randint(0, 255,3,np.uint8)
        frame[...] = color
        frameBuffer = Buffer(Packer.pack(frame,'cv::Mat'))
    server.stop()
