#!/usr/bin/env python

"""This filter exchanges all references to axis X and Y"""

import sys


def swap(content, x, y):
    content = content.replace(x, "@@@")
    content = content.replace(y, x)
    content = content.replace("@@@", y)
    return content

content = sys.stdin.read()
for x, y in (
    (".x", ".y"),
    ("_x", "_y"),
    ("vertical", "horizontal"),
    ("width", "height"),
    ("_hbox", "_vbox"),
    ):
    content = swap(content, x, y)

content = content.replace("padding_height", "padding_width")
content = content.replace("border_height", "border_width")
content = content.replace("focus_height", "focus_width")


sys.stdout.write(
    """
    
    /* Do not edit this file, it is generated by zmw-swap-coorinates.py */
    
    """ + content)

