# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2007 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#


from QUENLIG.questions import *
from .check import *

add(name="modle cisco",
    required=["tp1:intro"],
    question="""Quel est le modle du routeur CISCO
                que vous allez utiliser&nbsp;?
                La rponse est crite sur la face avant.
             """,
    tests=(
    HostCiscoModele(),
    ),
    indices = ("Vrifiez si vous n'avez pas fait une faute de typo", ),
    )

add(name="nb srie",
    required=['modle cisco'],
    question="""Combien y-a-t-il de ports sries permettant de faire des
    liaisons rseaux sur le routeur CISCO&nbsp;?""",
    tests=(
    require_int(),
    HostCiscoNrSerials(),
    ),
    bad_answer = """Ne comptez pas le port console, c'est une liaison
    srie, mais elle ne permet pas de faire du rseau""",
    )

add(name="nb ethernet",
    required=['modle cisco'],
    question="Combien a-t-il de ports ethernet sur le routeur CISCO&nbsp;?",
    tests=(
    require_int(),
    HostCiscoNrEthernet(),
    ),
    indices = ("""Ou vous regardez sur la documentation, ou vous regardez
    derrire le routeur.
    Attention, ce n'est pas la forme du connecteur qui vous dit si
    c'est ethernet ou non...""", ),
    )

add(name="on off",
    required=['modle cisco'],
    question="Le routeur CISCO a-t-il un interrupteur marche/arrt&nbsp;?",
    tests=(
    HostCiscoOnOff(),
    ),
    )

add(name="console eth",
    required=['nb ethernet'],
    before = """On a besoin de dtrompeur quand les trous dans lesquels
    on met les connecteurs se ressemblent suffisamment (ou sont identiques)
    pour que l'on se trompe.
    Par exemple&nbsp;:
    <ul>
    <li> La forme interne des connecteurs USB empche de les brancher  l'envers.
    <li> La forme externe des RJ45, port srie (DB-9/DB-25)
    et des cartes mmoires empche de les brancher  l'envers.
    <li> Sur les connecteurs IDE/SATA et lectrique que l'on branche
     l'intrieur des PC des trous manquants empchent de se tromper.
    <li> Il n'y a pas de dtrompeur sur les prises audio
    et d'alimentation lectrique en courant continu,
    on peut donc se tromper :-(.
    </ul>""",
    question="""Sur le routeur CISCO,
    y-a-t-il un dtrompeur pour vous empcher de connecter
    un cable ethernet RJ45 sur le connecteur nomm 'console'&nbsp;?""",
    tests=(
    no("Essayez de faire ce branchement pour vrifier."),
    ),
    good_answer= "Faites attention  ne pas vous tromper dans la suite du TP.",
    )


add(name="show",
    required=['modle cisco', 'cli:show liste', 'cli:commande incomplte'],
    question="""Quelle commande tapez-vous pour voir la configuration
    <b>matrielle</b> du routeur CISCO&nbsp;?
    <p>
    Attention, pour des raisons mystrieuses il est possible
    que <tt>show ha?</tt> n'affiche pas la bonne rponse...
    """,
    tests=(
    expect('show'),
    good("show hardware"),
    good("show version",
        "Pas trs logique comme rponse, comment dit-on matriel en anglais?"),
    ),
    indices = ("""Le paramtre est la traduction de <em>matriel</em>
    en anglais""", ),
    )


add(name="ram",
    required=['show'],
    before="""RAM : Random Access Memory
    <p>
    <em>Attention, ce que l'on appelle RAM n'est ni la mmoire
    <b>flash</b> ni la mmoire non volatile</em>.
    <p>
    Attention, le routeur CISCO n'affiche pas la quantit
    de RAM totale mais la RAM libre et la RAM utilise.
    <p>
    <table>
    <tr><th></th><th>Anglais</th><th>Franais</th></tr>
    <tr><td>Boolen</td><td>bit</td><td>bit</td></tr>
    <tr><td>8 bits</td><td>byte</td><td>octet</td></tr>
    </table>
    """,
    question="""Combien de RAM (en kilo-octets)
    y-a-t-il dans le routeur CISCO&nbsp;?
    """,
    tests=(
    require_int(),
    HostCiscoRAM(),
    ),
    indices = (
    """Dans la ligne indiquant la quantit de mmoire,
    le premier chiffre est la mmoire libre, et le deuxime
    la mmoire utilise par le systme.""",
    ),
    )
add(name="nvram",
    required=['ram'],
    before="""NVRAM : Non Volatile RAM.
    <p>
    Cette mmoire est utilise par le routeur pour sauvegarder
    sa configuration.
    Elle s'utilise comme de la mmoire normale bien que plus lente d'accs.
    """,
    question="""Combien de NVRAM (en kilo-octets)
    y-a-t-il dans le routeur CISCO&nbsp;?""",
    tests=(
    require_int(),
    HostCiscoNVRAM(),
    ),    
    )
add(name="flash",
    required=['nvram'],
    before="""<em>Flash</em> : C'est une sorte de NVRAM qui n'est pas chre mais
    qui lorsque que l'on crit dedans ncessite d'effacer et de rcrire
    un gros bloc de donnes.
    <p>
    De plus les mmoires <em>flash</em> s'usent en quelques dizaines
    de milliers d'critures.
    <p>
    De fait, dans les routeurs CISCO elles ne servent qu'
    stocker l'image du systme d'exploitation.
    <p>
    <a href="http://en.wikipedia.org/wiki/Flash_memory">wikipedia:flash</a>.
    """,
    question="""Quelle quantit de mmoire <em>flash</em> (en kilo-octets)
    y-a-t-il dans le routeur CISCO&nbsp;?""",
    tests=(
    require_int(),
    HostCiscoFlash(),
    ),    
    )


 



    



