# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

mv_required = require("mv", "On dplace/renomme les fichiers avec <tt>mv</tt>")

mv_shorter = reject("./a",
                    "<tt>a</tt> c'est plus court  crire que <tt>./a</tt>")


add(name="intro",
    required=["manuel:chercher"],
    before="""La commande permettant de dplacer (<em>move</em> en anglais)
    les fichiers d'un endroit  l'autre permet de les renommer.
    <p>
    Attention, si le fichier destination existe, il est dtruit
    pour tre remplac par le nouveau.
    <p>
    Attention, vous avez le droit de dplacer un fichier si vous
    avez le droit d'criture dans le rpertoire.
    Si c'est le cas, vous avez le droit de dplacer des fichiers
    sur lesquels vous n'avez aucun droit.
    """,
    question="""Quelle est la ligne de commande permettant de renommer
    le fichier <tt>a</tt> en <tt>b</tt> dans le rpertoire courant&nbsp;?""",
    indices=("La commande pour dplacer est <tt>mv</tt>",),
    tests=(
    reject('move', """Gnralement, les noms des commandes les plus utilises
    sont sur 2 caractres pour tre plus rapide  taper."""),
    shell_good("mv a b"),
    shell_good( ("mv ./a ./b", "mv a ./b", "mv ./a b"),
                "<tt>mv a b</tt> est plus simple et plus court"),
    reject(("A", "B"), "Sous Unix majuscule et minuscule sont diffrentes."),
    reject("rm", "C'est pour dtruire ! Pas pour dplacer !"),
    reject("cp", "C'est pour copier ! Pas pour dplacer !"),
    require(("a", "b"), "Vous voulez dplacer quoi&nbsp;?"),
    require('mv',
            "Je ne vois pas le nom de la commande permettant de renommer"),
    shell_display,
    ),
    )

add(name="rpertoire",
    question="""Donnez la commande la plus courte pour
    dplacer le fichier <tt>a</tt> du rpertoire courant
    pour le mettre dans le rpertoire <tt>/tmp</tt>
    sans lui changer son nom.""",
    tests=(
    shell_good("mv a /tmp"),
    shell_good("mv a /tmp/", "Le / final est inutile"),
    shell_bad(("mv a /tmp/a", "mv a /tmp/."), "Ce n'est pas la plus courte"),
    mv_required,
    mv_shorter,
    require('tmp', 'Et le rpertoire de destination, il est o&nbsp;?'),
    require('/tmp', """Pas dans le <tt>tmp</tt> du rpertoire courant,
    celui qui est  la racine"""),
    reject('-', "Vous n'avez pas besoin d'indiquer d'options"),
    shell_display,
    ),
    indices=("""Quand la destination est un rpertoire, les fichiers
    sont dplacs dans le rpertoire sans changer de nom""",),
    )

add(name="rpertoire et renomme",
    before="On suppose que <tt>/tmp/A</tt> n'existe pas",
    question="""Donnez la commande la plus courte pour
    dplacer le fichier <tt>a</tt> du rpertoire courant
    pour le mettre dans le rpertoire <tt>/tmp</tt>
    en le nommant <tt>A</tt>.""",
    tests=(
    shell_good("mv a /tmp/A"),
    shell_bad("mv a /tmp A",
              "Votre commande dplace <tt>a</tt> et <tt>tmp</tt> dans <tt>A</tt>"),
    shell_bad("mv a A /tmp",
              "Votre commande dplace <tt>a</tt> et <tt>A</tt> dans <tt>/tmp</tt>"),
    shell_bad("mv a tmp/A",
              "Dans le <tt>tmp</tt> de la racine, pas du rpertoire courant"),
    mv_required,
    mv_shorter,
    require("/tmp/A",
            "Il faut indiquer le nom de la destination (le nouveau nom)"),
    reject('-', "Vous n'avez pas besoin d'indiquer d'options"),
    shell_display,
    ),
    )






