# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#
import random
from questions import *
from check import *

reject_quotes = reject("'", "Il ne faut pas recopier les apostrophes&nbsp;!")

add(name="premire",
    before="""Cette question s'affiche en premier car sans prrequis.""",
    question="Rpondez 'bonjour'",
    tests=(reject_quotes,
           Good(Equal("bonjour")),
           Good(Comment(Equal("Bonjour"),
                "J'accepte la rponse bien que vous ayez mis une majuscule")),
           comment("crivez en bon franais s'il vous plais"),
           ),
    indices=("Vous devez crire 'bonjour' dans le rectangle blanc",
             "Aprs avoir crit la rponse, il faut taper &lt;Return&gt;",
             ),
    good_answer="Pour passer  la question suivante, tapez sur return",
    )

def question_aleatoire():
    a = random.randrange(0,100)
    b = random.randrange(0,100)
    return "%d + %d = ?" % (a, b)


class reponse_aleatoire(TestWithoutStrings):
    def test(self, student_answer, string):
        r = random.randrange(0,100) + random.randrange(0,100)
        if r == int(student_answer):
            return True, ""
        else:
            return False, "Vous vous trompez de %d" % (r - int(student_answer))

add(name='alatoire',
    required = [ 'premire' ],
    question=question_aleatoire,
    tests=(require_int(),
           reponse_aleatoire(),
           ),
    )

add(name='shell',
    required = [ 'premire' ],
    before="""Ce systme a t dvelopp pour analyser des rponses
    qui sont des commandes shell.
    <ul>
    <li> Il canonise les lignes de commande shell
    <li> Il traduit mme certaine options quivalentes.
    <li> Il affiche l'arbre syntaxique de la commande
    </ul>""",
    question="La rponse est 'ls -ls >toto'",
    tests=(shell_good('ls -ls >toto'),
           shell_display,
           ),
    nr_lines=15,
    default_answer="""
 ls $A $(A) '$A' "$A" "*" * \* |
 (
   read A
   echo $A >toto
   cat
 ) |
 while read A
 do
   for I in 1 2
      do
          echo $I
      done
 done >titi""",
    )

add(name='outils',
    required = [ 'premire' ],
    before = """Il est facile de faire plein de petits
    outils pour tester les rponses.
    Certaines existent dj :
    <tt>answer_length_is</tt>,
    <tt>number_of_is</tt>,
    <tt>require_int</tt>,
    <tt>comment</tt>,
    """,
    question = 'Rpondre "[[]]"',
    tests = (reject_quotes,
             answer_length_is(4, 'La rponse tient sur 4 caractres !'),
             number_of_is('[',2, "Il y a deux '['"),
             number_of_is(']',2, "Il y a deux ']'"),
             good('[[]]'),
             comment('Et il faut les mettre dans le bon ordre !'),
             ),
    )
    

add(name='requis simple',
    required = [ 'alatoire', 'shell', 'outils' ],
    before = """Pour rpondre  cette question, il faut avoir
    rpondu au 3 questions prrequises""",
    question = '?',
    tests = (good('?'), ),
    )

add(name='requis minuscule',
    required = [ 'premire(^[a-z].*)' ],
    before = """Vous voyez cette question car vous avez rpondu avec
    une minuscule  la premire question""",
    question = '?',
    tests = (good('?'), ),
    )

add(name='requis majuscule',
    required = [ 'premire(^[A-Z].*)' ],
    before = """Vous voyez cette question car vous avez rpondu avec
    une majuscule  la premire question""",
    question = '?',
    tests = (good('?'), ),
    )
