# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006,2011 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#


# FAIRe LES QUESTION . * ^ $ +

from questions import *
from check import *

aide = """La mthode la plus simple pour tester les expressions
    rgulire est d'excuter la commande suivante&nbsp;:
    <pre>sed -r 's/votre_expression_regulire/(((&)))/g'</pre>
    Vous tapez ensuite du texte au clavier et les chanes de caractres
    reconnues apparatront dans les triples parenthses."""

add(name="intro",
    required=["sh:console", "sh:configurer", "remplacer:intro"],
    before=aide,
    question="""Quelle expression rgulire reprsente une chane
    de caractre quelconque.""",
    tests=(
    good('.*'),
    bad('*', "Non a c'est un <em>pattern</em> pour le shell."),
    bad('*.', "L'toile multiplie ce qui prcde."),
    bad(".", "Cette expression rgulire reprsente un caractre quelconque"),
    reject("sed",
           """On demande le <em>pattern</em>,
           pas la ligne de commande permettant de le tester"""),
    reject("[",
           """Vous n'allez pas numrer tous les
           caractres possibles&nbsp;!
           N'utilisez pas les crochets."""),
    reject('?', """Le <tt>?</tt> indique un caractre quelconque pour
    les <em>pattern</em> du shell.
    On vous demande une expression rgulire"""),
    require(".",
            """On indique un caractre quelconque avec un '.'
            Une ligne quelconque est une rptition de caractres
            quelconques."""),
    reject('+', """Si vous utilisez le <tt>+</tt> pour multiplier ce qui
    prcde cela ne permettra pas de reprsenter une chaine vide
    car dans les expressions rgulires <b>tendues</b> il ne
    multiplie pas par zro."""),
    require("*",
            """On indique que l'on rpte ce qui prcde
            en utilisant le symbole <tt>*</tt>"""),
    reject("\\.*",
           """<tt>\\.*</tt> reprsente une srie
           de points de longueur quelconque"""),
    reject(("'",'"'),
           """On dsire l'expression rgulire,
           on ne se soucie pas du shell,
           donc on ne veut pas de <tt>'</tt> ou <tt>\"</tt>
           """),
    ),
    good_answer="Par dfaut la chane tient dans une seul ligne",
    indices = (
    """C'est la rptition un nombre indtermin de fois
    d'un caractre quelconque""",
    ),
    )

partie = " Donc la ligne conviendra mme si elle ne contient pas que des <tt>A</tt> :-("

add(name="ligne de A",
    question="""Quelle expression rgulire <b>tendue</b> reprsente les
    lignes non vides ne contenant que des caractres A et rien d'autre""",
    tests=(
    good('^A+$'),
    good(('^[A]+$', '^(A)+$', '^AA*$'),
         "Il est plus simple d'crire <pre>^A+$</pre>"
         ),
    bad(('^A*$', '^[A]*$', '^(A)*$'),
        "Ce n'est pas bon car cela reprsente aussi les lignes vides."),
    bad('^A$', "Ceci reprsente les lignes contenant un seul A"),
    require("^",
            """Si vous n'indiquez pas qu'elle commence au dbut de la ligne,
            l'expression rgulire peut commencer n'importe o.""" + partie),
    require("$",
            """Si vous n'indiquez pas qu'elle finit  la fin
            de la ligne, l'expression rgulire peut finir n'importe o.""" +
            partie),
    reject("[",
           """Pas besoin de spcifier une liste de
           lettres car il n'y en a qu'une seule&nbsp;: A"""),
    reject(" ",
           """Si vous mettez un espace cela veut dire que vous dsirez
           que la chaine de caractre contienne un espace."""
           ),
    number_of_is('A', 1,
                 """Votre rponse ne doit contenir qu'un
                 seul caractre <tt>A</tt>"""),
    ),
    indices=("Le caractre <tt>^</tt> indique le dbut de ligne",
    "Le caractre <tt>$</tt> indique la fin de ligne",
    ),
    )

add(name="un spcial",
    required=["intro"],
    question="""Quelle expression reprsente le caractre point (<tt>.</tt>)
    au lieu de reprsenter un caractre quelconque&nbsp;?""",
    tests=(
    good( ("\\.", "[.]") ),
    require('.', "Je ne vois pas de caractre <tt>.</tt> dans votre rponse"),
    bad( ".", "Cette expression reprsente un caractre quelconque"),
    reject(('"',"'"),
           """Une expression rgulire n'a pas la mme syntaxe que le
           shell, les apostrophes et guillemets ne sont pas spciaux"""),
    reject('\\\\', """Votre expressions demande  avoir un caractre
    <em>backslash</em> car c'est lui que vous avez protg."""),
    ),
    indices=("""Attention le <tt>.</tt> est un caractre spcial,
    il faut annuler sa signification""",
             """Le caractre d'chappement dans les expressions
             rgulire est \\""",
             ),
    )

add(name="deux spcial",
    required=["un spcial"],
    question="""Quelle expression rgulire reprsente la chaine de caractres <tt>2*</tt> (un chiffre deux suivi d'une toile)&nbsp;?""",
    tests=(
    good( ("2\\*", "2[*]") ),
    bad( "2*", "Cette expression reprsente une suite de 2"),
    bad('[0-9]\*',
        """Cette expression reprsente un chiffre suivi d'une toile,
        on vous demande un <tt>2</tt> suivi d'une toile."""),
    require('2', 'Je ne vois pas de 2 dans votre rponse&nbsp;!'),
    require('*', 'Je ne vois pas de * dans votre rponse&nbsp;!'),
    reject(('"',"'"),
           """Guillemets et apostrophes sont reconnus par le shell
           pas par les expressions rgulires,
           vous devez utiliser autre chose pour annuler
           la signification de l'toile"""),
    reject('\\2', "Pourquoi protger le 2, il n'est pas spcial"),
    reject('2\\\\*', "Cette expression reprsente un 2 suivi d'antislashs."),
    reject('[2*]', '<tt>[2*]</tt> reprsente un <tt>2</tt> ou une toile'),
    reject('[2\\*]',
           '''<tt>[2\\*]</tt> reprsente un <tt>2</tt>, un <tt>\\</tt> ou
           une toile'''),
    ),
    indices=("""Attention le <tt>*</tt> est un caractre spcial,
    il faut annuler sa signification""",
             """Le caractre d'chappement dans les expressions
             rgulire est \\""",
             ),
    )

add(name="spcial",
    required=["un spcial", "intro"],
    question="""Quelle expression reprsente les lignes compltes
    contenant un caractre <tt>.</tt> quelque part&nbsp;?
    """,
    tests=(
    good( (".*\\..*", ".*[.].*") ),
    bad( ("\\.","[.]"),
         """L'expression reprsente le <tt>.</tt> pas la ligne complte"""),
    bad(".*\\.*",
        """Cette expression indique une chaine de caractres quelconque
        suivie d'une suite de caractres point."""),
    bad(("*.*", "*'.'*", '*"."*', "*\\.*"),
        """C'est la bonne rponse pour les <em>pattern</em>
        du shell. Mais on vous demande une expression rgulire"""),
    reject(('[',']'), """Pas besoin de crochets,
    Utilisez plutt un anti-slash pour annuler les significations
    des caractres spciaux"""),
    require(".*",
            """On ne veut pas que le '.' mais aussi
            la chaine de caractres quelconques
             sa gauche et  sa droite."""),
    reject(("^", "$"),
           """Pas la peine de spcifier les indicateurs
           de dbut/fin de ligne car le <tt>.*</tt>
           prend la plus grande chaine possible.
           Donc jusqu'au bout"""),
    number_of_is('.*', 2, """Il y a deux chaines de caractres quelconques,
    une  gauche et une  droite du point"""),
    number_of_is('\\', 1, """Il y a un seul caractre spcial pour lequel
    la signification doit tre annule, vous n'avez donc besoin
    que d'un seul anti-slash"""),
    
    ),
    indices=(
    """L'expression solution reprsente une chaine de caractres quelconques
    suivie d'un point suivie d'une chaine de caractres quelconques""",
    """La rponse la plus courte tient en 6 caractres""",
    """N'oubliez pas que le <tt>.*</tt> correspond
     la plus longue chane possible""",
             ),
    )

add(name='ngation',
    before=aide,
    required=["intro"],
    question="""Quelle expression rgulire reprsente un caractre qui ne soit
    ni une lettre de l'alphabet en minuscule ni un chiffre""",
    tests=(
    reject("!", "La ngation n'est pas la mme que celle du shell"),
    reject(".",
           """Vous n'avez pas besoin du caractre '<tt>.</tt>',
           il n'y a aucun caractre quelconque ici."""),
    reject(('(', ')'), "Vous n'avez pas besoin de parenthses"),
    reject('A', "Pas en minuscule, j'ai pas dis pas en majuscule"),
    reject("^[a", """La ngation est le premier caractre aprs
    le crochet. Sinon elle indique un dbut de ligne."""),
    reject(' ', "Attention, les espaces sont significatifs"),
    reject(('+', '*'), "On cherche un seul caractre, pas une suite"),
    reject('$', "Le caractre est n'importe o sur la ligne"),
    reject(('ab','12'),
           """Ne lister pas tous les caractres un par un.
           Dfinissez un interval de caractres avec les crochets."""),
    
    require(("[", "]"),
            """Il faut spcifier une liste de caractres en utilisant
            les crochets"""),
    require("-", "Il faut utiliser le <tt>-</tt> pour indiquer un intervalle"),
    require("^", "Je ne trouve pas le caractre indiquant <em>tout sauf</em>"),
    number_of_is('^',1,
                 """Vous ne devez employer la ngation qu'une seule fois"""),
    require('0-9', """Je ne trouve pas l'intervalle indiquant tous les
    chiffres de 0  9 inclus"""),
    require('a-z', """Je ne trouve pas l'intervalle indiquant toutes les
    lettres de 'a'  'z' inclus"""),
    good("[^a-z0-9]"),
    good("[^0-9a-z]",
         """J'attendais <tt>[^a-z0-9]</tt>, j'accepte votre
         solution car elle fonctionne mais s'il vous plais
         ne changez pas l'ordre de ce qui es demand dans l'nonc."""),
    expect('a-z0-9'),
    ),
    )

add(name='suite de chiffres',
    before=aide,
    required=["intro"],
    question="""Quelle expression reprsente des suites de chiffres
           quelconques d'au moins un chiffre (mme <tt>000</tt>
           ou <tt>01</tt> par exemple)""",
    tests=(
    reject('sed',
           "On ne veut pas la commande, seulement l'expression rgulire"),
    bad("[0-9]*", """Cette expression correspond aussi  une chaine vide,
    mais nous recherchons les chaines contenant au moins un chiffre"""),
    bad('[:digit:]+', """C'est une expression rgulire qui rpond
     la question, mais on vous demande une solution qui n'utilise
    que des connaissances de base."""),
    require(('0-9','[','-',']'),
            "Je ne trouve pas l'intervalle des chiffres de 0  9"),
    reject('.', """Une suite de chiffre ne contient pas de caractres
    quelconques, pourquoi indiquez-vous le caractre '.'&nbsp;?"""),
    reject(('(',')'), "Pas besoin de parenthser"),
    reject(('[0-9]+[0-9]*', '[0-9]*[0-9]+'),
           """Vous pouvez faire deux fois plus court.
           En effet votre expression dcrit deux suites de chiffres
           l'un colle  l'autre"""),
    good( "[0-9]+",
    "C'est un expression rguire tendue car vous utilisez <tt>+</tt>"),
    good( "[0-9][0-9]*" ),
    good( "[0-9]*[0-9]", "On crit plutt <tt>[0-9][0-9]*</tt>" ),
    require(('*','+'), """Je ne vois pas le symbole indiquant que l'on rpte
    les chiffres""", all_agree=True),
    ),
    )

add(name='entier positif',
    before=aide,
    required=["suite de chiffres"],
    question="""Quelle expression rgulire tendue reprsente
    des suites de chiffres
    ne commenant pas par <tt>0</tt> sauf pour le nombre <tt>0</tt>.
    Exemple de ce que l'on doit trouver&nbsp;:
           
           <pre>dfsfd<span class='boxed'>67</span>sdfsfds-<span class='boxed'>0</span>sdfdsf++<span class='boxed'>0</span><span class='boxed'>8090</span>dsfs<span class='boxed'>0</span><span class='boxed'>0</span>ppp</pre>


           """,
    tests=(
    reject('sed', "On veut l'expression rgulire, pas la commande"),
    reject('[^0]',
           """<tt>[^0]</tt> indique un caractre quelconque sauf <tt>0</tt>
           Par exemple <tt>A</tt>"""),
    bad(('[1-9]+[0-9]*|0', '([1-9]+[0-9]*|0)'),
        """Cette solution est correcte mais vraiment pas naturelle.
        Vous obtiendrez la bonne rponse en enlevant
        une caractre de la votre..."""),
        
    reject('^', "On a pas besoin de <tt>^</tt>"),
    reject('+', """N'utilisez pas le <tt>+</tt> il n'est pas utile ici.
    Je pense que vous devriez plutt utiliser <tt>*</tt>"""),
    reject('.',
           "Un nombre entier, pas un nombre flottant, donc pas de point"),
    reject(' ', """Si vous mettez un espace dans une expression rgulire,
    cet espace devra tre trouv"""),
    reject('[0]', "Il est plus simple d'crire <tt>0</tt> que <tt>[0]</tt>"),
    require('|', """Il faut utiliser un <b>ou</b>, en effet,
    c'est zro ou un nombre de commenant pas par zro."""),
    require('[0-9]',
           "Vous n'autorisez pas les nombres  contenir des 0&nbsp;: 608"),
    require('[1-9]', """Vous n'indiquez pas que le premier chiffre est
    entre 1 et 9"""),
    require('*', """Vous n'indiquez pas qu'il y a un nombre indfini de
    chiffre aprs le premier (y compris aucun)"""),

    good( "0|[1-9][0-9]*" ),
    bad( "0|([1-9][0-9]*)",
         "Cela fonctionne, mais les parenthses ne sont pas au bon endroit"),
    good( "(0|[1-9][0-9]*)" ),
    good( "[1-9][0-9]*|0" ),
    good( "([1-9][0-9]*|0)" ),
        
    ),
    )

class test_nombre_entier(bad):
    def test(self, a, string):
        if a.find("\\") != -1:
            return False, "Il n'y a pas besoin d'antislash pour cette question"
        if a.find("[1-9]") == -1:
            return False, '''Tous les nombres entiers commencent par un chiffre
            diffrent de 0 sauf 0.'''
        if " " in a:
            return False, '''Les espaces sont <b>significatif</b>'''
        if a.find("|") == -1:
            return False, "0 est un cas  part car on ne lui met pas un signe"
        if a.count("|") > 1:
            return False, '''Un seul | suffit, ne compliquez pas inutilement'''
        if a[0] != "(" or a[-1] != ")":
            return False, """Je n'accepterais la solution que si vous
            parenthsez le <tt>ou</tt>,
            crivez <tt>(a|b)</tt> au lieu de <tt>a|b</tt>"""
        if a.find("[0-9]*") == -1:
            return False, """La fin d'un nombre entier contient un nombre
            indfini de nombre entre 0 et 9."""
        if a.find("[+-]") != -1:
            return False, """Si une liste de caractres entre crochets contient
            '-' il faut le mettre en premier. Sinon il reprsente un intervalle."""
        if a.find("[-+][0-9]") != -1 or a.find("[-+]?[0-9]") != -1:
            return False, """Un nombre entier ne commence pas par 0 sauf 0"""
        if a.find("[-+][0-9]") != -1:
            return False, """Un nombre entier peut tre crit sans signe."""
        return False, """Si aprs avoir test votre expression rgulire elle
        vous semble juste alors laissez un commentaire pour le faire savoir."""
    
    

add(name='nombre entier',
    required=["entier positif"],
    before=aide,
    question="""Quelle expression rgulire tendue reprsente les nombres
    entiers avec leur signe&nbsp;:
    <pre>dfsfd<span class='boxed'>+6</span>sdfsfds-<span class='boxed'>0</span>sdfdsf++<span class='boxed'>0</span>sdfs<span class='boxed'>89</span>dsfs<span class='boxed'>-45</span>sdff+<span class='boxed'>-342</span>fd<span class='boxed'>56</span>ssfsdf<span class='boxed'>0</span><span class='boxed'>76</span>werwer-<span class='boxed'>0</span><span class='boxed'>89</span>sdf\\<span class='boxed'>106</span></pre>
    Les boites indiquent les nombres que votre expression rgulire doit trouver.
    """,
    tests=(    
    good( ('([-+]?[1-9][0-9]*|0)',
           '(0|[-+]?[1-9][0-9]*)',
           '((-|+|)[1-9][0-9]*|0)',
           '(0|(-|+|)[1-9][0-9]*)',
           '((+|-|)[1-9][0-9]*|0)',
           '(0|(+|-|)[1-9][0-9]*)'
           ) ),
    good( '(0|+[1-9][0-9]*|-[1-9][0-9]*)',
          "Il est plus court d'crire : <pre>(0|[-+]?[1-9][0-9]*)</pre>"),
    bad( ('(0|[-+][1-9][0-9]*)', '([-+][1-9][0-9]*|0)'),
          "Cela ne trouve pas les nombre sans signe."
          ),
    reject('[1-9]+', "Il y a un + qui n'est pas ncessaire..."),
    bad( ('(0|([-+]?[1-9][0-9]*))', ),
          "Cela fonctionne, mais faites plus court (parenthses en trop)."
          ),
    test_nombre_entier(),
    ),
    )
    
    
add(name="identique",
    question="""Quelle expression rgulire tendue reprsente les
    lignes ne contenant que des caractres identiques.
    """,
    tests=(
    reject(('a','A'),
           "Que vient faire un <tt>a</tt> dans votre rponse&nbsp;?"),
    require(('(',')'),
            """Vous devez grouper des caractres et rutiliser le texte
            trouv par le groupe"""),
    require(('^', '$'),
            """Vous devez indiquer le dbut et la fin de ligne sinon
            l'expression pourra correspondre  une suite de caractres
            identiques en plein milieu"""),
    require('\\1', """Vous devez utiliser les caractres trouvs par le groupe
            pour indiquer que le reste de la ligne est identique"""),
    good('^(.)\\1*$'),
    good('(^.)\\1*$', "Je prfre : <tt>^(.)\\1*$</tt>"),
    bad('^(.)\\1+$', """Presque, mais cela ne trouve pas
    les lignes d'un seul caractre"""),
    reject('+', "Vous ne devez pas utiliser le <tt>+</tt>"),
    require_startswith('^', """Pour ce problme,
    le <tt>^</tt> doit tre en dbut d'expression rgulire""") ,
    require_endswith('$', """Pour ce problme,
    le <tt>$</tt> doit tre en fin d'expression rgulire""") ,
    bad('^(.)\\1$', """Vous trouvez seulement les lignes contenant
    deux caractres identiques"""),
    ),
    indices=("""Il faut mettre le premier caractre de la ligne dans
    un groupe et dire que le reste de la ligne est la rptition
    du contenu de ce groupe""",
             """Les groupes sont dfinis par les parenthses&nbsp;:
             <tt>a(.*)b(.*)c</tt>
             <p>
             Cette expression dfinit 2 groupes sans les utiliser.
             """,
             """Les groupes sont nomms anti-slash numro de groupe.
             <tt>\\1</tt> est le numro du premier groupe.
             """,
             """Pour cette exercice, le premier groupe est un caractre
             quelconque et la suite de la ligne est une rptition
             du premier groupe.
             """,
             ),
    )


