#!/usr/bin/env python
# -*- coding: latin1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2007 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr

import statistics

container = 'action'
link_to_self = True
priority_execute = '-question_answer'

def execute(state, plugin, argument):
    if argument == None:
        return ''
    
    stats = statistics.question_stats()

    s = []
    for e in stats.all_students:
        if e == state.student:
            continue
        if e.the_number_of_good_answers < 1:
            s.append('%s(%s)' %(e.name, e.the_number_of_good_answers))
            e.destroy()
            
    plugin.heart_content = ('<p class="deleted"><br>' +
                                  '<br>\n'.join(s)
                                 )
    state.question = None

    return ''














