#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr

"""Some special pages generated on the right side"""

import utilities
import cgi
import student
import questions
import statistics
import random
import configuration
import acls
import sre
import casauth
import sys

def page_stopped():
    return "<P CLASS=\"stopped\"></P>"

def page_home(state):
    return "<P CLASS=\"choose\"></P>"

def page_help(state):
    return """
    <OBJECT type="text/html" data="help.html" width="100%" height="2000px">
    <p class=\"object_unsuported\"></p>
    </OBJECT>"""

def page_deconnection(state):
    return ('text/html',
            "<script>window.location = '%s' ;</script>" %  casauth.logout_url()
            )

def page_comment(state):
    return utilities.div('your_comment',"<PRE>" + state.comment + "</PRE>")

def fill_required(state):
    s = ""
    for p in state.question.required.names():
        s += "<P>"
        s += utilities.div("question",
                           questions.questions[p].question(state) % state.data,
                           top=' : ' + p)
        try:
            s += utilities.div('your_answer', utilities.answer_format(state.student.answers[p].answered))
        except KeyError:
            pass
    if s != "":
        state.data["required"] = utilities.div('requireds', s)

def absolute_and_relative(v, n):
    if n:
        return "%d (%g)" % ( v, v/float(n) )
    else:
        return "%d" % v

def fill_question_stat(state):
    statistics.question_stats()
    question = state.question
    if question.student_given == 0:
        return

    s = "<table class=\"short\"><tr valign=\"TOP\"><td>"
    s += "<p class=\"question_given\">%d</p>"%question.student_given
    s += "<p class=\"question_view\">%s</p>" % \
         absolute_and_relative(question.student_view, question.student_given)
    s += "</td><td>"
    s += "<p class=\"question_good\">%s</p>" % \
         absolute_and_relative(question.student_good, question.student_given)
    s += "<p class=\"question_bad\">%s</p>" % \
         absolute_and_relative(question.student_bad, question.student_given)
    s += "</td><td>"
    s += "<p class=\"question_indice\">%s</p>" % \
         absolute_and_relative(question.student_indice, question.student_given)
    s += "<p class=\"question_time\">%s (%s)</p>" % (
        utilities.time_format(question.student_time),
        utilities.time_format(question.student_time/
                              (0.1 + question.student_given) ) )
    s += "<p class=\"question_comment\">%s</p>" % \
         absolute_and_relative(question.student_nr_comment,
                               question.student_given)
    s += "</td></tr></table>"

    state.data["question_stat"] = utilities.div('one_question_stat', s) % \
                                  state.data


def fill_question_html(state):
    state.data["question"] = state.student.question_html(state.question,state=state) % state.data
    
def fill_entry_html(state):
    if state.student.answered_question(state.question.name) \
           and not state.student.acls["question_answerable_any"]:
        s = state.student.last_answer(state.question.name)
        s = utilities.answer_format(s)
        s = utilities.div('answer_given', s)
        state.data["entry"] = s
        return

    if state.question.tests == ():
        return
    
    s = """<FORM CLASS=\"answer\" METHOD=\"GET\" ACTION=\"#\">
    <input name=\"action\" value=\"question_answerable\" type=\"hidden\">
    """
    last_answer = state.student.last_answer(state.question.name)
    if last_answer == "":
        last_answer = state.question.default_answer
    if state.question.nr_lines == 1:
         s += "<INPUT TYPE=\"text\" ID=\"2\" NAME=\"value\" SIZE=\"%d\" VALUE=\"%s\"><br>\n" % (
             configuration.nr_columns,
             cgi.escape(last_answer).replace("%","&#37").replace("'", "&#39;").replace('"', '&#34;'))
    else:
         s += "<TEXTAREA NAME=\"value\" ID=\"2\" COLS=\"%d\" ROWS=\"%d\">%s</TEXTAREA>" % (
              configuration.nr_columns,
              state.question.nr_lines,
              cgi.escape(last_answer).replace("%","&#37"))
         s += "\n<br><button class=\"action_answer\" type=\"submit\"><p></p></button>\n"
    if state.student.acls["gui_autofocus"]:
        s += "<script type=\"text/javascript\">document.getElementById(2).focus();</script>"
    s += '</FORM>'
    state.data["entry"] = utilities.div('answer', s)
    
def fill_indices_html(state):
    if ( len(state.question.indices)==0
         or not state.student.acls['question_indice_see']
         or state.student.answered_question(state.question.name)
         ):
        return ""
    indice = state.student.get_indice(state.question.name) + 1
    indice = min(indice, len(state.question.indices))
    s = ""
    if indice > 0:
        indices = [ ind%state.data for ind in state.question.indices[:indice] ]
        s += utilities.list_format(indices)
    if indice < len(state.question.indices):
        if indice == 0:
            html_class = 'give_first_indice'
        else:
            html_class = 'give_next_indice'
        s += "<A CLASS=\"%s\" HREF=\"?action=question_indice_see\"></A>" % html_class
    state.data["indices"] = utilities.div('indices', s)

# Returns True is correctly answered
def fill_answer_comments(state, answer=None):    
    # Caching ???
    if state.data['good_answer'] or state.data['bad_answer']:
        return

    if answer == None:
        answer = state.student.last_answer(state.question.name)
        if answer == '':
            return False

    number, message = state.student.check_answer(state.question,
                                                 answer, state)

    if True:
        answered = ""
    else:
        answered = utilities.answer_format(answer) + "<br>"

    if state.question.evaluate_answer:
        state.data['evaluated_answer'] = utilities.div(
            "evaluated_answer", state.question.evaluate_answer(answer, state))
    
    if number:
        state.data['good_answer'] = utilities.div("good_answer",
                                                  answered + message)
        if state.question.good_answer:
            state.data['good_answer'] += utilities.div("do_you_know"
                                               , state.question.good_answer)
    else:
        state.data['bad_answer'] = utilities.div("bad_answer",
                                                 answered + message)
        if state.question.bad_answer:
            state.data['bad_answer'] += utilities.div("may_be"
                                              , state.question.bad_answer)

    return number

def extract_question(c, function):
    """Extract a question definition from the python source.
    Extract some text before.
    Bugs:
       - Inside the 'add' the text must not go to the first column
       """
    
    function = sre.escape(function)
    c = sre.sub('\nadd[ \t]*\(', '\n', c) # simplify the not matching

    lines_starting_by_space_or_empty = "(\n+[ \t][^\n]*)*"

    not_an_add = "\n+[a-zA-Z][^\n]*"
    not_an_add_bloc = not_an_add + lines_starting_by_space_or_empty
    
    the_add = '\n+name=[\'"]'+ function + '[\'"][^\n]*'
    the_add_bloc = the_add + lines_starting_by_space_or_empty
    
    interesting_part = "(" + not_an_add_bloc + ")*" + the_add_bloc
    
    c = sre.sub('(?s)(' + interesting_part + ")", '\\1', c)
    c = sre.sub('(?s).*', '', c)
    c = sre.sub('(?s).*', '', c)
    c = c.replace('', 'add(')

    return c

def fill_source(state):
    import os
    
    f = open( os.path.join(configuration.root, configuration.questions,
                           state.question.world + ".py"), "r")
    c = f.read()        
    f.close()

    c = extract_question(c, state.question.short_name)

    f = open('xxx.source.py', 'w')
    f.write(c)
    f.close()
    f = os.popen('highlight --xhtml xxx.source.py ; grep -v "body" <highlight.css >HTML/highlight.css', 'r')
    c = f.read().replace('highlight.css', '/highlight.css')
    f.close()

    return c
    


def page_question(state):
    if state.stopped:
        return page_stopped()

    answerables = state.student.answerables()

    if state.question == None:
        return ""

    if not (state.student.acls["question_answerable_any"]
            or state.question in answerables
            or state.student.answered_question(state.question.name)
            ):      
        sys.stderr.write("%s try to answer not allowed question %s\n" % (
            state.student.name, state.question.name))
        state.question = None
        return ""

    
    state.student.tell_question(state.question.name)

    s = state.student.acls.a_href('answers_reload', br='')
    if s:
        s = '<span style="font-size:50%">' + s + '</span> '
    state.data['h1'] = s + cgi.escape(state.question.name)

    if state.student.acls["question_time_see"]:
        stats = statistics.question_stats()
        if state.question.student_given > 2:
            t = state.question.student_time/state.question.student_given
            state.data['h1'] += ' <a class="question_time_see tips">%s<span></span></a>'% \
                                utilities.duration(t)

    fill_question_html(state)
    fill_entry_html(state)
    fill_indices_html(state)

    # Ici on doit dcider d'afficher toutes les mauvaises rponses
    # et les commentaires associs
    fill_answer_comments(state)

    
    if state.student.acls["question_required_see"] \
           and not state.student.answered_question(state.question.name):
        fill_required(state)
    if state.student.acls["answered_bad_see"]:
        state.data["bad_answers"] = page_bad_answers(state,state.question.name)
    if state.student.acls["answered_comments_see"]:
        state.data["comments"] = page_comments(state,state.question.name)
    if state.student.acls["answers_html_see"]:
        state.data["answers"] = state.question.answers_html(state)
    if state.student.acls["stat_questions_see"]:
        fill_question_stat(state)

    s = ''
    if state.student.acls["answers_source_see"]:
        s += fill_source(state)

    return s

def page_bad_answers(state, question=None):
    stats = statistics.question_stats()

    ba = []
    for s in stats.all_students:
        for a in s.answers.values():            
            if question and a.question != question:
                continue
            for c in a.bad_answers:
                commented = s.answer_commented(a.question ,c)
                c = utilities.answer_format(c)
                if not commented:
                    # Uppercase in order to display them first when sorted
                    c = "<SPAN class=\"uncommented\">" + c + "</span>"
                elif commented == '*':
                    c = "***!!!" + c + "!!!***"
                else:
                    c = '<a class="tips">%s<span>%s</span></a>' %(c, commented)
                    
                name = s.a_href()
                if not a.answered:
                    name = "<b>" + name + "</b>"
                if a.indice != -1:
                    name = "<em>" + name + "</em>"
                ba.append( [questions.a_href(a.question),c, name] )

    ba.sort()
    new_ba = []
    for x in ba:
        if new_ba and x[0] == new_ba[-1][0] and x[1] == new_ba[-1][1]:
            new_ba[-1][2] += ", " + x[2]
        else:
            new_ba.append(x)
    ba = new_ba

    return utilities.sortable_table('bad_answers_stat',state.sort_column, ba)

def page_plot(state):
    return ""

def student_stat_title(state):
    if state.student_stat:
         state.data['title'] = state.student_stat.name

def student_submenu(state, action):
    if not state.student.acls[action]:
        return ""
    
    stats = statistics.question_stats()
    s = []
    for st in stats.all_students:
        s.append( st.a_href(action='&action=' + action) + "<br>\n" )
    s.sort()
    return utilities.div('student_submenu hide_on_print', ''.join(s), menu='menu')

##############################################################################
##############################################################################
# See/Look at
##############################################################################
##############################################################################

def see_submenu(state):
    state.question = None

    if not (
        state.student.acls['answers_html_see']
        or state.student.acls['answers_graph']
        or state.student.acls['answered_comments_see']
        ) :
        return

    s = ''
    s += state.student.acls.a_href('answered_see')
    s += state.student.acls.a_href('answers_html_see')
    s += state.student.acls.a_href('answers_graph')
    s += state.student.acls.a_href('answered_comments_see')

    state.data['submenu'] = utilities.div('see_submenu hide_on_print', s, menu='menu') + student_submenu(state, 'answered_see_other')

def _page_answered(state, student):
    see_submenu(state)
    student_stat_title(state)
    return student.answered_page(state)

def page_answered(state):
    return _page_answered(state, state.student)

def page_answered_student(state):
    if state.student_stat == None:
        return page_answered(state)
    return _page_answered(state, state.student_stat)

def page_comments(state, question=None):
    if question == None:
        see_submenu(state)

    stats = statistics.question_stats()
    
    comments = []
    for s in stats.all_students:
        for a in s.answers.values():
            if question and a.question != question:
                continue
            q = questions.a_href(a.question)
            for c in a.comments:
                comments.append( [q,
                                  c[1],
                                  s.mailto(body=str(a.question) + "  " + c[1]),
                                  utilities.date_format(c[0])])
    return utilities.sortable_table('comment_stat',state.sort_column, comments)

def page_graph(state):
    see_submenu(state)
    return """<A HREF=\"xxx.ps\"><IMG SRC=\"xxx.png\"></a>"""

def page_answers(state):
    see_submenu(state)
    s = ""
    for question in questions.sorted_questions:
        s += question.answers_html(state)
    try:
         return s % state.data
    except ValueError:
         print s
         return s


##############################################################################
##############################################################################
# ACLS
##############################################################################
##############################################################################

def fill_acl_submenu(state):
    state.question = None

    if not (
        state.student.acls['acl_default_see']
        or state.student.acls['acl_see_other']
        ) :
        return

    s = ''
    s += state.student.acls.a_href('acl_see')
    s += state.student.acls.a_href('acl_default_see')
    s += state.student.acls.a_href('role_student_see')
    s += state.student.acls.a_href('role_teacher_see')
    s += state.student.acls.a_href('role_author_see')
    s += state.student.acls.a_href('role_admin_see')
            
    state.data['submenu'] = utilities.div('acl_submenu hide_on_print', s, menu='menu') + student_submenu(state, 'acl_see_other')

def acl_button(acl_value, acl, remove=True):
    s = "<SELECT name=\"%d\" class=\"acl_button\" OnChange=\"a(value,'%s');\">" % (
        acl_value, acl )
    options = [('+', acl_value == 2), ('&nbsp;', acl_value == 1)]
    if remove:
        options += [('-', acl_value == 0)]
    for i, v in options:
        s += "<OPTION"
        if v:
            s += " SELECTED=1"
        s += ">" + i + "</OPTION>\n"
    s += "</SELECT>"
    return s

def javascript_acl(change_acl_action):
    return     """
    <script>
    function a(value, acl)
    {
    if ( value == '+' )
       value = 'Y' ;
    if ( value == ' ' )
       value = '.' ;
    window.location = '?action=%s&value=' + value + acl ;
    }
    </script>""" % change_acl_action

def _page_acl(state, the_acls, change_acl_action):
    acl_change = state.student.acls[change_acl_action]

    fill_acl_submenu(state)

    s = []
    for a in acls.all_acls.keys():
        the_acls.state = state # XXX Not nice
        h = '<p class="help_' + a + '"></p>'
        perm = (' class="acl_have_not"', ' class="acl_have"')[int(the_acls[a])]
        aa = ('', a, perm)
        if acl_change:
            s.append( [aa, h, acl_button(the_acls.get(a), a) ] )
        else:
            s.append( [aa, h, '<p class="r%d"></p>' % the_acls.get(a) ] )
        
    return javascript_acl(change_acl_action) \
        + '<form action=\"#\">' \
        + utilities.sortable_table('acls acls_' + \
                                   change_acl_action.replace('_change','_see'),
                                   state.sort_column,s) \
        + '</form>'

def page_acl(state):
    return _page_acl(state, state.student.acls, "acl_change")

def page_acl_student(state):
    if state.student_stat == None:
        return page_acl(state)
    student_stat_title(state)
    return _page_acl(state, state.student_stat.acls, "acl_change_other")

def page_default_acls(state):
    return _page_acl(state, configuration.acls_default, "acl_default_change")
def page_role_student(state):
    return _page_acl(state, configuration.acls_student,
                     "role_student_change")
def page_role_author(state):
    return _page_acl(state, configuration.acls_author,
                     "role_author_change")
def page_role_admin(state):
    return _page_acl(state, configuration.acls_admin,
                     "role_admin_change")
def page_role_teacher(state):
    return _page_acl(state, configuration.acls_teacher,
                     "role_teacher_change")


##############################################################################
##############################################################################
# STATS
##############################################################################
##############################################################################

def fill_statistics_submenu(state):

    state.question = None

    if not (
        state.student.acls['stat_questions_see']
        or state.student.acls['stat_others_see']
        or state.student.acls['stat_others_csv_see']
        or state.student.acls['stat_plot_see']
        or state.student.acls['stat_see_other']
        or state.student.acls['stat_histogram_good_see']
        ) :
        return
    s = ""

    s += state.student.acls.a_href('stat_see')
    s += state.student.acls.a_href('stat_questions_see')
    s += state.student.acls.a_href('stat_others_see')
    s += state.student.acls.a_href('stat_others_csv_see')
    s += state.student.acls.a_href('stat_plot_see')
    s += state.student.acls.a_href('stat_histogram_good_see')
    s += state.student.acls.a_href('stat_histogram_level_see')
    s += state.student.acls.a_href('stat_same_time_see')
    s += 'TTL %6.2f' % statistics.question_stats().ttl + 's<br>'

    state.data['submenu'] = utilities.div('stat_submenu hide_on_print', s, menu='menu') + student_submenu(state, 'stat_see_other')

def _page_stat(state, student, action):
    fill_statistics_submenu(state)
    s = student.stat(state.sort_column)
    if state.student.acls['question_pixel_map_see_other']:
        s += '<img width="15%%" src="?action=question_pixel_map_see_other&student=%s">' % student.filename
        
    s += state.student.acls.a_href(action)
    return s

def page_stat(state):
    return _page_stat(state, state.student, 'answered_reset')

def page_stat_student(state):
    if state.student_stat == None:
        return page_stat(state)
    student_stat_title(state)
    return _page_stat(state, state.student_stat, 'answered_reset_other')

def page_histogram_level(state):
    fill_statistics_submenu(state)

    histogram = statistics.histogram_level()
    t = "<pre>"
    for level, nr in zip(range(len(histogram)),histogram):
        t += "%3d : " % level + "*" * nr + '\n'
    t += '</pre>'
    
    return t

def page_student_csv(state):
    stats = statistics.question_stats()
    if stats.max_good_answers == 0 or stats.max_bad_answers == 0 \
           or stats.max_given_indices == 0:
        return 'text/comma-separated-values', '?,?,?,?,?'
    content = []
    for s in stats.all_students:
        content.append(
            (
            s.filename,
            s.the_number_of_good_answers / float(stats.max_good_answers),
            s.the_number_of_bad_answers / float(stats.max_bad_answers),
            s.the_number_of_given_indices / float(stats.max_given_indices),
            (s.the_time_searching + s.the_time_after)/3600.,
            ))
    content.sort()

    t = "Nom,Bonne,Mauvaise,Indices,Heures\n"
    t += ",1:beaucoup,1:beaucoup,1:beaucoup,\n"
    for c in content:
        t += "%s, %4.2f, %4.2f, %4.2f, %4.1f\n" % c
        
    return 'text/comma-separated-values', t

def plot_svg(state):
    return 'image/svg+xml', statistics.plot_svg(state.data['url_base'])

def page_histogram_good(state):
    fill_statistics_submenu(state)
    stats = statistics.question_stats()

    div = int(state.form.get("value", "10"))
    histo = [0] * (1 + stats.max_good_answers/div)
    for s in stats.all_students:
        histo[ s.the_number_of_good_answers/div ] += 1
    t = "<pre>"
    for h in range(len(histo)):
        t += ("%3d-%3d : " % (h*div, (h+1)*div-1))  +  "*" * histo[h] + "\n"
    t += '</pre>'

    return t


styles = {
    -2: "style='background-color:#FF0000;'",
    -1: "style='background-color:#FFA0A0;'",
    0: "",
    1: "style='background-color:#A0FFA0;'",
    2: "style='background-color:#00FF00;'",
    }

def page_student_stats(state):
    fill_statistics_submenu(state)
    stats = statistics.question_stats()

    content = []
    for s in stats.all_students:
        nr_good_answers = (styles[s.warning_nr_good_answers],
                           s.the_number_of_good_answers)
        nr_bad_answers = (styles[s.warning_nr_bad_answers],
                          s.the_number_of_bad_answers)
        nr_given_indices = (styles[s.warning_nr_given_indices],
                            s.the_number_of_given_indices)
        time_after = (styles[s.warning_time_after],
                      utilities.time_format(s.the_time_after))

        line = [
            s.a_href(),
            nr_good_answers,
            s.the_number_of_given_questions,
            nr_bad_answers,
            nr_given_indices,
            s.the_number_of_comment,
            utilities.time_format(s.the_time_searching),
            time_after,
            utilities.date_format(s.the_time_first),
            utilities.date_format(s.the_time_last),
            "%3.1f" % s.nr_of_same_time_normed,
            int(s.the_time_variance),
            ]

        if state.student.acls['question_pixel_map_see_other']:
            line.append('<img src="?action=question_pixel_map_see_other&student=%s">' % s.filename)

        content.append(line)
    return utilities.sortable_table('students_stat',state.sort_column, content)

def page_see_same_time(state):
    fill_statistics_submenu(state)
    stats = statistics.question_stats()

    st = "<TABLE class=\"information_table\" cellspacing=1>"
    for s in stats.sorted_students:
        st += "<TR><TH>%s</TH>" % s.a_href()
        for ss in stats.sorted_students:
            try:
                n = (10*s.nr_answer_same_time[ss.name]/float(s.the_number_of_good_answers))
            except KeyError:
                n = 0
                
            if n < 3 :
                color = ""
            elif n < 4 :
                if abs(s.the_number_of_good_answers - ss.the_number_of_good_answers)<2:
                    color = styles[-1]
                else:
                    color = styles[1]
            else:
                if abs(s.the_number_of_good_answers - ss.the_number_of_good_answers)<2:
                    color = styles[-2]
                else:
                    color = styles[2]
            st += "<TD %s>%d</TD>" % (color, n)
        st += "</TR>\n"
    st += "</TABLE>"

    return st

def page_question_stats(state):
    fill_statistics_submenu(state)
    stats = statistics.question_stats()
    nr_students = float(len(stats.all_students))

    s = []
    for question in questions.questions.values():
        norme = float(question.student_given)
        if question.student_given == 0:
            continue
        s.append([
            question.a_href(),
            "%6.3f" % (question.student_given  / nr_students),
            "%6.3f" % (question.student_view   / norme),
            "%6.3f" % (question.student_good   / norme),
            "%6.3f" % (question.student_bad    / norme),
            "%6.3f" % (question.student_indice / norme),
            utilities.time_format(question.student_time  / norme),
            "%6.3f" % (question.student_nr_comment/ norme),
            ])

    if s:
        return utilities.sortable_table('question_stat', state.sort_column, s)
    else:
        return ""







    




