# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2007 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *
from configuration_salles import *

add(name="cable console",
    required=['hard:console eth'],
    before="""Un cable bleu ciel doit relier votre ordinateur
    au routeur CISCO.
    Il permet de communiquer avec le routeur alors que celui-ci n'est
    pas encore configur (il n'a pas d'accs rseau).
    <ul>
    <li> Sur l'ordinateur il est branch sur la RS232C,
    qui est une prise <a href="http://fr.wikipedia.org/wiki/Image:Sub-D_male_9p.jpg">DB9</a> qui contient 9 broches sur 2 ranges.
    La premire sortie RS232C s'appelle <tt>/dev/ttyS0</tt> sous Linux
    et <tt>COM1</tt> sous windows.
    </li>
    <li> sur le routeur CISCO, il est branch sur la RS232C,
    qui est une prise RJ45 <b> ne pas confondre avec une prise Ethernet</b>.
    Le mot <em>console</em> est crit  cot du connecteur.
    </li>
    </ul>
    <p>
    Une liaison srie (RS232C) permet d'avoir un flux d'octet bidirectionnel
    entre les 2 machines.
    <p>
    Historiquement, un <b>terminal</b> tait la composition d'un <b>cran</b>
    qui affichait ce que la liaison srie envoyait et
    tout ce qui tait tap au <b>clavier</b> tait envoy sur
    la liaison srie.
    <p>
    L'abbrviation TTY dsigne <em>teletype</em>.
    <ul>
    <li> <tt>/dev/ttyS0</tt> : Premire liaison srie.</li>
    <li> <tt>/dev/tty0</tt> : Premire console texte.</li>
    <li> <tt>/dev/pts/0</tt> : Premire TTY virtuelle
    (pour la fentre terminal par exemple)</li>
    </ul>
    """,
    question = """Rpondez OUI quand le cable sera correctement branch.""",
    tests = (yes("Alors branchez-le&nbsp;!"),),
    )


add(name="minicom",
    required=['cable console'],
    before="""
    Il faut lancer une application sur l'ordinateur qui
    permet de faire comme si l'on avait branch un terminal
    sur le routeur CISCO.
    <p>
    Techniquement cette application fait un peu mieux que&nbsp;:
    <ul>
    <li> <tt>stty /dev/ttyS0 9600</tt> : Configuration de la liaison srie.
    <li> <tt>cat /dev/ttyS0 &amp;</tt> : Affichage de ce que le routeur CISCO envoie.
    <li> <tt>cat &gt;/dev/ttyS0</tt> : Envoi de ce qui est tap au clavier au routeur CISCO</li>
    </ul>
    <p>
    L'application que vous devez utiliser est <tt>minicom</tt>.
    <p>
    Si <tt>minicom</tt> proteste  cause d'un verrou et qu'il
    est lanc une seule fois alors dtruisez le verrou (<tt>/var/lock/...</tt>)
    """,
    question = """Ouvrez un terminal et lancez <tt>minicom</tt>.
    Que devez-vous taper pour avoir l'aide sur <tt>minicom</tt>&nbsp;?
    <p>
    Attention : ne lancez pas <tt>minicom</tt> en arrire plan,
    il a besoin d'utiliser le clavier et l'cran.
    """,
    tests = (
    reject('man', """On veut l'aide en ligne du logiciel, pas sa
    page de manuel. Si vous venez de lancer <tt>minicom</tt> la
    rponse est crite sous yeux."""),
    require( ('A', 'Z', 'CTRL'),
             """Je ne trouve pas tous les lments de la rponse.
             Faites un copi/coll de la squence de caractres.""",
             uppercase=True),
    good_if_contains( '' ),
    ),
    indices = ("""La rponse est affiche par <tt>minicom</tt>
    quand vous le lancez.""", ),

    )



add(name="minicom parameters",
    required=['minicom'],
    question = """Que tapez-vous dans <tt>minicom</tt>
    pour faire apparatre le menu vous permettant
    de configurer la vitesse de la ligne, la parit,
    le nombre de bits de donnes, ...""",
    tests = (
    require('P', """C'est dans le menu <em>Comm parameters</em> de la
    page d'aide de <tt>minicom</tt>""",
            uppercase=True),
    good_if_contains( '' ),
    ),
    )



add(name="line parameters",
    required=['minicom parameters'],
    question = """Configurez la ligne srie avec
    une vitesse de 9600 baud, 8 bits de donnes et 1 stop bit.
    <p>
    Rpondez OUI si c'est fait.""",
    tests = (yes("Alors configurez-la correctement&nbsp;!"),),
    )



add(name="allumer CISCO",
    required=['line parameters', 'tp1:stop'],
    before = """Maintenant vous devez pouvoir communiquer avec le routeur CISCO.
    <p>
    Allumez le routeur CISCO.
    <p>
    Des messages de dmarrage doivent dfiler.
    <p>
    Si le routeur pose la question <em>Do you want to enter the inital configuration dialog&nbsp;?</em>
    rpondez no pour qu'il s'initialise tout seul sans poser de questions.
    <p>
    Quand la procdure de dmarrage semble termine, tapez plusieurs
    fois sur <tt>return</tt> pour voir ce que le routeur CISCO rpond.
    <p>
    Si un mot de passe est demand et que vous ne le trouvez pas,
    suivez la procdure d'effacement de mot de passe indique
    dans la page d'aide/explication du menu de gauche.
    """,
    question = """Quel est le prompt (l'invite de commande)&nbsp;?""",
    tests = (
    # Anglais
    good('Router>'),
    bad('router>', "Vous n'auriez pas oubli une majuscule&nbsp;?"),
    bad('Router' , "Vous n'auriez pas oubli un caractre&nbsp;?"),
    bad('router' , "On veut la chaine de caractre exacte."),
    # Franais
    bad(('routeur>', 'Routeur>'),
        "Vous avez mal lu... vous l'avez traduit en franais"),
    bad(('Routeur', 'Routeur'),
        "Vous avez traduit et en plus vous avez oubli un caractre&nbsp;!"),
    
    reject('rommon', """Votre routeur a perdu son systme&nbsp;?
Faites un arrt marche et si le prompt est le mme
suivez la procdure indique dans la page d'aide/explication du menu de gauche."""),
    require('jamaisimpossible',
        """Les tudiants du TP prcdents n'ont pas fait le mnage avant
        de terminer le TP.
        Suivez la procdure d'effacement de configuration indique
    dans la page d'aide/explication du menu de gauche.
    """),
    
    ),
    indices = (reinit, ),

    )



add(name="aide commande",
    required=['allumer CISCO'],
    before = """Quand vous tapez une commande, vous pouvez  n'importe
    quel moment taper un point d'interrogation pour obtenir&nbsp;:
    <ul>
    <li> La liste des noms de commandes/paramtres qui commencent
    par le mot que vous avez commenc  taper&nbsp;;</li>
    <li> La syntaxe de la commande si son nom est complet&nbsp;;</li>
    <li> Les paramtres possibles si vous avez commenc  taper
    un nom de paramtre&nbsp;;</li>
    <li> Les valeurs possibles pour un paramtre si le nom
    du paramtre est complet.</li>
    </ul>""",
    question = "Combien de commandes ont un nom qui commence par 's'&nbsp;?",
    tests = (
    require_int(),
    good("3"),
    good("4"),
    bad("5", """Non, il y a la mme commande deux fois.
    En effet <tt>*s=show</tt> indique que vous pouvez taper <tt>s</tt>
    au lieu de <tt>show</tt>"""),
    ),
    good_answer = """ATTENTION : dans certains cas des commandes
    existantes et expliques dans la documentation n'apparaissent
    pas de la liste fournie par le point d'interrogation""",
    )
    


add(name="? seul",
    required=['aide commande'],
    question = """Si vous tapez un '?' seul comme commande,
    voyez-vous la commande <tt>configure</tt>&nbsp;?""",
    tests = (no("""Si vous la voyez c'est que vous tes pass en mode
    privilgi sans que l'on vous l'ai demand"""),
             ),
    good_answer = """On ne voit pas cette commande car elle est
    accessible seulement en mode privilgi""",
    )



add(name="voir",
    required=['aide commande', 'doc:intro'],
    before="""<b>Attention, pour la suite des TP seuls les noms
    complets de commande seront accepts, aucune abrviation
    que cela soit pour les commandes et les paramtres ne sera accepte.\n""",
    question=""" votre avis, quelle est la commande vous permettant
    d'avoir des informations (matriel, logiciel, configuration, ...) sur le routeur&nbsp;?""",
    tests = (
    reject(" ", "Le nom de la commande sans paramtres s'il vous plais."),
    bad(('s','sh','sho'), "Aucune abrviation n'est autorise."),
    good("show"),
    ),
    )



add(name="show",
    required=['aide commande', 'voir'],
    before="""Deux moyens pour rpondre  cette question&nbsp;:
    <ul>
    <li> Essayer btement.
    <li> Ou faire liste les premier paramtres possible en utilisant
    le point d'interrogation comme premier paramtre.
    </ul>""",
    question="La commande <tt>show</tt> prend-elle des paramtres&nbsp;?",
    tests = ( yes("Vous n'avez pas essay&nbsp;?"), ),
    )


add(name="copi coll",
    required=['show'],
    before="""Faites un copi/coll des 3 commandes suivantes sur le routeur&nbsp;:
    <pre>show clock
show hardware
show history</pre>""",
    question="""Qu'elle est la dernire ligne affiche par le routeur
    ( part l'invite de commande)&nbsp;?""",
    tests = (
    good("show history"),
    good("how history",
        """Il y a actuellement un bug avec le copi/coll.
        Nous ne savons pas d'ou il vient,
        certainement du contrle de flux sur la RS232C.
        <p>
        Excutez <tt>show history</tt> pour voir ce que cela fait.
        """),
    ),
    )


add(name="commande incomplte",
    required=['show'],
    question = """Est-ce que c'est bien <tt>show</tt>
    qui s'excute si vous tapez <tt>sho clock</tt>
    au lieu de <tt>show clock</tt>&nbsp;?""",
    tests = ( yes("Montrez cela  un enseignant"), ),
    good_answer = """Cela fonctionne car vous avez tapez suffisemment
    de lettres de la commande pour qu'il n'y ai pas d'ambigut.
    Cette pratique est dconseille quand on fait des script.
    <p>
    <b>DANS LA SUITE DU TP, TOUTE COMMANDE INCOMPLTE SERA REFUSE</b>
    """,
    )
    


add(name="dition ligne",
    required=['show'],
    before="""Sur la ligne de commande du routeur,
    tapez 'shw version' sans valider par <tt>Return</tt>
    puis modifiez la ligne de commande afin
    de transformer la ligne en <tt>show version</tt> en utilisant
    les touches curseur <b>sans utiliser le <em>backspace</em></b>.
    <p>
    <img src="clavier.png" align="left">
    Jaune : le backspace<br>
    Orange : Carriage Return<br>
    Bleu : Flche curseur gauche
    """,
    question="Est-ce que vous pouvez le faire&nbsp;?",
    tests = ( yes("Montrez cela  un enseignant"), ),
    )



add(name="show liste",
    required=['aide commande', 'show'],
    before="""Le premier paramtre de la commande <tt>show</tt>
    permet de choisir ce que l'on peut voir.
    Faites afficher l'ensemble des possibilits pour
    ce premier paramtre.""",
    question = """Combien de premiers paramtres possibles
    commencent par la lettre 'h'&nbsp;?""",
    tests = ( require_int(),
              good("4"),
              good("3"),
              good("2"), # Anciens IOS
              ),
    )

add(name="mauvaise commande",
    required=['show'],
    before="""Lancez la commande&nbsp;: <tt>coucou</tt>.
    <p>
    Comme cela n'est pas une commande, le routeur considre que
    c'est le nom d'une machine.
    Il commence donc par essayer de trouver son adresse IP.
    il essaie 3 fois.
    """,
    question="""Sans teindre le routeur, arrivez-vous  arrter
    le processus de recherche&nbsp;?
    <p>
    <small>
    Si jamais la recherche est instantane et que
    le <em>prompt</em> revient tout de suite alors rpondez NON
     la question. Cela veut dire que votre routeur n'a
    pas la configuration par dfaut.

    """,
    tests = ( no("Montrez comment vous avez fait  un enseignant"), ),
    )

add(name="historique",
    required=['dition ligne', 'copi coll'],
    question="""Pouvez-vous utiliser la flche curseur vers le haut
    pour revenir dans l'historique et diter d'anciennes commandes&nbsp;?""",
    tests = ( yes("Ressayez"), ),
    )


add(name="fin dition",
    required=['historique', 'commande incomplte', '? seul', 'show liste'], # 'mauvaise commande',
    before = """La rponse  cette question n'est pas lie  <tt>minicom</tt>
    de plus elle fonctionne sur tous les terminaux virtuels et sur
    la console Linux.""",
    question="""Sans utiliser la souris et l'ascenseur,
    que tapez-vous au clavier pour voir ce qui a dfil au dessus
    de l'cran&nbsp;?""",
    tests = (
    require(('SHIFT', 'SHFT', 'MAJ'), uppercase=True, all_agree=True),
    require(('PAGE', 'PG'), uppercase=True, all_agree=True),
    require(('UP', 'HAUT'), uppercase=True, all_agree=True),
    good_if_contains(''),
    ),
    indices = (
    """C'est <tt>shift + page up</tt>""",
    ),
    )
