# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

add(name="intro",
    before="""<IMG SRC="Sunrise_over_the_sea.jpg" align="right">
    <p>
    Bonjour %(student_name)s
    <p>
    Pour rpondre aux questions, c'est trs simple&nbsp;:
    vous tapez le texte de votre rponse dans le champs texte
    ci-dessous et vous tapez sur la touche qui s'appelle
    &lt;Return&gt;
    ou &lt;Enter&gt;
    ou &lt;Entre&gt;
    <p>
    Normalement, vous n'avez besoin de la souris que pour
    faire le copier/coller.
    En effet, s'il n'y a pas de rponse  donner,
    le lien sur la prochaine question est activ (il a le <em>focus</em>)
    et il vous suffit de taper &lt;Return&gt;
    pour suivre le lien.""",
    question="Rpondez 'bonjour'  cette question.",
    tests=(
    good('bonjour'),
    good("'bonjour'",
     """Je vous accorde la rponse mais les apostrophes
     taient l uniquement pour sparer le mot du reste de la phrase.
     """),
    good("Bonjour",
     """Je vous accorde la rponse, mais vous ne deviez
     pas mettre de majuscule.
     """),
    reject("echo", "Ce n'est pas une question Unix"),
    ),
    indices=(
    """Cher %(student_name)s, vous devez taper la rponse dans
    la zone de saisie qui normalement est blanche et qui est
    juste au dessus.""",
    ),
    good_answer="""La rponse attendue  toutes les questions
    que vous aurez  donner par la suite sera <b>la plus courte</b>.
    Les rponses qui ne sont pas minimales en nombre de caractres
    seront refuses.""",
    )

add(name="combien de titres",
    required=["intro"],
    question="""Combien y-a-t-il de titres de boites dans la colonne
    de gauche de cette page web&nbsp;?""",
    tests=(
    good("5"),
    require_int
    ),
    )

def check_nr_possible_questions(a, state=None):
    try:
        return len(state.student.answerables()) == int(a), ""
    except:
        return None, ""


add(name="questions possibles",
    required=["intro"],
    question="""Combien y-a-t-il de questions diffrentes
    dans la liste des questions que vous avez le droit
    de choisir maintenant&nbsp;?""",
    tests=(
    check_nr_possible_questions,
    require_int
    ),
    )

def check_nr_questions(a):
    try:
        return len(questions) == int(a), ""
    except:
        return None, ""

add(name="questions en tout",
    required=["intro"],
    question="""Quel est le nombre total de questions
    qui sont prvus dans ce sujet de TP&nbsp;?""",
    tests=(
    check_nr_questions,
    require_int
    ),
    indices=(
             "C'est indiqu dans les statistiques",
             "C'est le nombre de questions en tout."
             ),
    )

def check_nr_items(a):
    import server
    nb = server.get_file("help.html").content.count('<li>')
    a = int(a)
    if a == nb:
        return True, ""
    if a < nb:
        return False, """N'auriez-vous pas oubli de compter les puces
        de deuxime niveau&nbsp;?"""
    return False, "Recomptez, vous vous tes tromp"

add(name="aide",
    required=["questions en tout"],
    before="Lisez la page d'aide/explication.",
    question="""Combien de puces (<em>item</em>) sont affiches
    sur la page d'aide accessible dans le menu de gauche&nbsp;?""",
    tests=(
    require_int,
    check_nr_items,
    ),
    indices=("""La puce est le petit symbole que l'on trouve
     gauche d'un paragraphe quand on fait une numration""",
             ),
    )

add(name="commentaire",
    required=["indices"],
    before="""La grande zone en bas  gauche permet de taper
    des commentaires  propos des questions&nbsp;:
    <ul>
    <li> L'nonc vous pose un problme (ambigu, fautes d'orthographe, ...)
    <li> Une rponse correcte est refuse sans explication.
    <li> Les indices ne sont pas suffisants ou faux.
    <li> Il manque des prrequis.
    <li> ...
    </ul>
    Aprs avoir tap un commentaire il faut cliquer
    sur le bouton pour l'envoyer.
    <p>
    <b>Tout</b> ce que vous faites
    est enregistr afin que les enseignants puissent
    valuer votre travail.
    """,
    question="""Combien de lignes de commentaires peut-ont crire
    dans la zone de commentaires sans que le texte tap
    se dcale vers le haut&nbsp;?""",
    tests=(
    good( ("10", "11") ),
    require_int
    ),
    )

add(name="indices",
    required=["intro"],
    question="""Combien d'indices vous donne-t-on pour rpondre
     cette question&nbsp;?""",
    tests=(
    good("2"),
    bad("1",
        """S'il n'y avait qu'un seul indice, le lien se serait nomm.
        <p>
        <em>Donnez-moi l'indice</em>
        <p>
        Et non :
        <p>
        <em>Donnez-moi un indice</em>
        """),
    require_int,
    ),
    indices=("Je suis le premier indice",
             "Je suis le deuxime indice"),
    )

add(name="humour",
    required=["indices"],
    question="Quel est la rponse  cette question&nbsp;?",
    tests=(
    good("42"),
    bad("humour", "Trs astucieux, flicitation. Mais ce n'est pas a."),
    require_int,
    ),
    indices=("La rponse  cette question est <tt>42</tt>", ),
    )

add(name="meta",
    required=["humour"],
    question="<tt>Quel</tt> est la rponse  cette question.",
    tests=(
    good("Quel"),
    good("quel", "Accept, mais c'tait avec une majuscule"),
    ),
    indices=(
    """Lisez bien la phrase en sparant les mots qui font partie
    de la phrase de ceux qui sont le sujet de la phrase.
    <p>
    A ne pas lire pendant la sance de TP : <A HREF='http://www.abbottandcostello.net/who.htm'>Who's On First</A>""",
    """Avez-vous vous remarqu que les mots de la phrases
    ne sont pas tous dans la mme fonte&nbsp;?""",
    """La question n'a pas de point d'introgation, ce n'est
    donc pas une question, mais une rponse :-)""",
             ),
    )


def check_nr_good_answers(a, state=None):
    try:
        return state.student.number_of_good_answers() == int(a), ""
    except:
        return None, ""

add(name="rpondre",
    required=["combien de titres", "questions possibles", "questions en tout",
              "commentaire"],
    before="""Vous savez maintenant utiliser ce programme pour
    rpondre aux questions.""",
    question="""A combien de questions avez vous rpondu correctement
    sans compter celle-ci&nbsp;?""",
    tests=(
    check_nr_good_answers,
    require_int
    ),
    )
