# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

add(name="intro",
    required=["sh:console"],
    question="""Quelle est la commande permettant d'crire sur
    la sortie standard le contenu d'un ou plusieurs fichiers&nbsp;?""",
    tests=(
    good("cat"),
    bad((">", ">>"),
        """Ce n'est pas une commande mais un indicateur permettant
        de rediriger la sortie d'une commande dans un fichier"""),
    reject(("echo", "vi", "ls"),
           "Cette commande ne lit pas le contenu des fichiers"),
    ),
    )

cat_required = require("cat", "On utilise <tt>cat</tt> pour concatner")

cat_files_required = require(("/etc/passwd", "/etc/group"),
                             "Il faut indiquer les noms des fichiers !")

cat_once_indices = "Il ne faut appeler <tt>cat</tt> qu'une fois"

add(name="concatener",
    question="""Donner la ligne de commande permettant d'crire
    le contenu de <tt>/etc/passwd</tt> et <tt>/etc/group</tt>
    sur l'cran&nbsp;?""",
    tests=(
    shell_good("cat /etc/passwd /etc/group"),
    cat_required,
    cat_files_required,
    number_of_is('cat',1,"On n'utilise <tt>cat</tt> qu'une seule fois"),
    reject(">",
           """La concatnation s'affiche sur l'cran,
           pas dans un autre fichier"""),
    shell_display,
    ),
    indices=(cat_once_indices,
             ),
    )

add(name="concatener dans",
    required=["concatener", "sh:redirection sortie"],
    question="""Donner la ligne de commande permettant d'crire
    le contenu de <tt>/etc/passwd</tt> et <tt>/etc/group</tt>
    dans le fichier <tt>xxx</tt> du rpertoire courant
    (en le vidant ou crant).""",
    tests=(
    shell_good("cat /etc/passwd /etc/group >xxx"),
    cat_required,
    number_of_is('cat',1,"On n'utilise <tt>cat</tt> qu'une seule fois"),
    cat_files_required,
    reject("./xxx", """Le <tt>./</tt> devant <tt>xxx</tt> est inutile"""),
    reject(">>",
           """Vous devez crer <tt>xxx</tt> en une seul fois.
           Donc pas besoin d'ajouter  la fin"""),
    reject("<", """On redirige la sortie, pas l'entre"""),
    require("xxx", "Vous devez stocker le rsultat dans <tt>xxx</tt>"),
    shell_display,
    ),
    indices=(cat_once_indices,
             ),
    )




    
