#!/usr/bin/env python
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

"""
Rename some variable in all the files
"""

import os
import sre

def files():

    explore = ['.']

    while explore:
        directory = explore.pop()
        c = os.listdir(directory)
        for i in c:
            fullname = os.path.join(directory, i)
            if os.path.isdir(fullname):
                explore.append(fullname)
            else:
                if i == 'acl':
                    yield fullname

translate = (
    ('le_toto', 'le_grand_toto'),
)

for filename in files():
    print filename
    
    f = open(filename, 'r')
    c = f.read()
    f.close()

    c = '\n' + c + '\n'
    for old, new in translate:
        c = sre.sub('\n' + old + '\n', '\n' + new + '\n', c)
        c = sre.sub('\n!' + old + '\n', '\n' + new + '\n', c)
    c = c[1:-1]

    f = open(filename, 'w')
    f.write(c)
    f.close()
