# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr

import os
import sys
from questions import *
import questions
import cgi

f = os.popen('sudo -u nobody echo ok', 'r')
if f.read() != 'ok\n':
    sys.stderr.write("""Please use the command 'visudo' to add the line:
login_name_of_the_user_running_the_server ALL=(nobody) NOPASSWD: ALL

This allow the server to use 'sudo nobody'
""")
    sys.exit(1)
f.close()


global_evals = {}

def python_eval(v):
    """Eval a python with a cache"""
    if global_evals.has_key(v):
        return global_evals[v]
    
    f = open("xxx.py", "w")
    f.write("""# -*- coding: latin-1 -*-\n""")
    f.write(v)
    f.close()
    # sudo :                              exco ALL=(nobody) NOPASSWD: ALL
    f = os.popen('ulimit -t 1 ; ulimit -v 10000 ; sudo -u nobody python xxx.py 2>&1', 'r')
    displayed = f.read()
    f.close()

    global_evals[v] = displayed

    return displayed

def answer_cleaning(v, remove_spaces=False, remove_newline=False):
    if remove_spaces:
        v = v.replace(' ', '')
    if remove_newline:
        v = v.replace('\n', '')
    return v

def python_answer(v, comment=''):
    if comment:
        comment = comment + "</p><p>"
    return comment + "Le Python rpond : <pre>" + cgi.escape(v).replace('\n', '&nbsp;\n') + '</pre>'

# With this the Python answer good or bad is always displayed.
questions.current_evaluate_answer = lambda answer, state: python_answer(python_eval(answer))

def python_answer_testing(v, html_class, return_value,
                          test_function=None,
                          comment="", 
                          remove_spaces=False, remove_newline=False):
    v = answer_cleaning(v, remove_spaces, remove_newline)
    def pag(answer, get_answer=False):
        if get_answer:
            return get_answer_html(html_class + ' test_python',
                                   (v,), comment)
        aa = python_eval(answer)
        a = answer_cleaning(aa, remove_spaces, remove_newline)
        if test_function(a,v):
            return return_value, comment
        else:
            if True:
                return None, ""
            else:
                s = ''
                for aa,bb in zip(a,v):
                    s += '%s(%d) %s(%d) %s<br>\n' % (aa,ord(aa),bb,ord(bb),aa==bb)
                return None, s
    return pag


def python_answer_good(v,comment="",remove_spaces=False,remove_newline=False):
    return python_answer_testing(v, 'test_good test_is', True,
                                 lambda a,v: a == v,
                                 comment,
                                 remove_spaces, remove_newline)
def python_answer_good_but(v,comment="",remove_spaces=False,remove_newline=False):
    return python_answer_testing(v, 'test_bad test_is', None,
                                 lambda a,v: a == v,
                                 comment,
                                 remove_spaces, remove_newline)
def python_answer_bad(v, comment="",remove_spaces=False,remove_newline=False):
    return python_answer_testing(v, 'test_bad test_is', False,
                                 lambda a,v: a == v,
                                 comment,
                                 remove_spaces, remove_newline)

def python_answer_reject(v,comment="",remove_spaces=False,remove_newline=False):
    return python_answer_testing(v, 'test_bad test_reject', False,
                                 lambda a,v: v in a,
                                 comment,
                                 remove_spaces, remove_newline)

def python_display(answer):
        return None, "Le Python rpond : <pre>" + cgi.escape(python_eval(answer)).replace('\n', '&nbsp;\n')+ '</pre>'


print_required = require(
    "print",
    """Il faut utiliser le mot <tt>print</tt> pour lui dire
    <em>dis-moi</em> sinon il ne te dira rien""")

apostrophe_required = require(
    "'",
    """Il faut mettre des apostrophes autour de ce que tu veux faire
    rpter au Python""")

apostrophe_rejected = reject(
    "'",
    """Il ne faut pas mettre des apostrophes autour des nombres
    et des oprations, sinon Python ne les comprend pas""")

space_required = require(
    " ",
    """Le Python est comme toi, pour qu'il comprenne une phrase
    forme de mot, il prfre que les mots soient spars les
    uns de autres par un espace.""")

plus_required = require(
    '+',
    "Tu as oubli le '+' pour faire l'addition")

minus_required = require(
    '-',
    "Tu as oubli le '-' pour faire la soustraction")

multiply_required = require(
    '*',
    "Tu as oubli le '*' pour faire la multiplication")

comma_required = require(
    ',',
    "Tu as oubli la virgule qui veut dire <em>et</em>")

comma_rejected = reject(
    ',',
    "On a pas besoin de la virgule pour rpondre  cet exercice.")

lf_required = require(
    '\\n',
    "Tu as oubli un <tt>\\n</tt> pour lui dire de revenir  la ligne.")

bracket_required = require(
    ('(', ')'),
    """Tu as oubli de mettre des parenthses pour que
    le Python calcule dans le bon ordre.""")

square_bracket_required = require(
    ('[', ']'),
    """Tu as oubli de mettre des crochets <tt>[</tt>
    et <tt>]</tt> pour indiquer le devant et l'arrire de
    la couverture du classeur.""")

for_required = require(
    ('for ', 'in', ':'),
    """Pour feuilleter un classeur, il faut respecter la phrase&nbsp;:<br>
    <tt>for page in classeur:</tt>
    """)

if_required = require(
    ('if ', ':'),
    """Pour faire un <em>si</em> il faut utiliser le mot <tt>if</tt>
    et mettre un <tt>:</tt> aprs la condition.
    """)

else_required = require(
    ('else', ':'),
    """Pour faire un <em>sinon</em> il faut utiliser le mot <tt>else</tt>
    suivi d'un <tt>:</tt>""")

egality_required = require(
    '==',
    """Pour tester si deux choses sont gales,
    il faut utiliser <tt>==</tt> (oui, il faut 2 =)""")

in_required = require(
    'in',
    """Pour savoir si quelque chose est dans un classeur
    on utilise le mot Python <tt>in</tt>.
    <p>
    <tt>5 in [4,6,7]</tt> rpond <tt>False</tt>""")

not_required = require(
    'not',
    """C'est le mot <tt>not</tt> qui indique la ngation.
    Pour faire l'exercice, tu en as besoin.
    """)

less_than_required = require(
    '<',
    """Pour tester si une chose est plus petite qu'une autre,
    il faut utiliser <tt>&lt;</tt>""")

def range_required(value=None):
    if value == None:
        return require('range', "On doit utiliser <tt>range</tt>")
    return require(('range', str(value)),
                   """Utilise <tt>range</tt> pour faire une classeur
                   contenant les nombres de 0  %d""" % (value-1))


def do_not_cheat(rejected=None, required=None):
    cheat_message = """C'est Python qui doit trouver la rponse, pas toi.
    Il doit faire les calculs tout seul sans que tu l'aides.
    """
    if rejected != None:
        return reject(rejected, cheat_message)
    if required != None:
        cheat_message += """On doit trouver dans la phrase Python
        les lments suivants&nbsp;:""" + str(required)
        return require(required, cheat_message)

replace_required = require(
    ('.', 'replace', '('),
    """Il faut utiliser <tt>.replace(</tt> pour faire le remplacement."""
    )
