#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr

import configuration
import time
import pages
import acls
import questions
import statistics

###############################################################################
# Actions modifying state but not displaying HTML
###############################################################################

def student_make_comment(state):
    state.comment = state.form["value"]
    if state.question:
        q = state.question.name
    else:
        q = "None"
    state.student.add_a_comment(q, state.comment)

def student_asks_indice(state):
    if state.question:
        state.student.tell_indice(state.question.name)
            
def student_answers(state):
    if state.question == None:
        return
    answer = state.form.get('value','')
    if pages.fill_answer_comments(state, answer):
        state.student.good_answer(state.question.name, answer)
    else:
        state.student.bad_answer(state.question.name, answer)

def student_make_reset(state):
    state.student.reset()

def student_make_reset_student(state):
    state.student_stat.reset()

def action_server_stop(state):
    configuration.dates = (0,time.time()-1)
    state.compute_stopped()

def action_server_start(state):
    configuration.dates = (time.time()-1, 2000000000)
    state.compute_stopped()

def action_deconnection(state):
    del states[state.ticket]

def answers_reload(state):
    if state.question == None:
        return
    # Remove old questions
    module_name = state.question.world
    q = {}
    for i in questions.questions.values():
        if i.world != module_name:
            q[i.name] = i
    questions.questions = q
    questions.previous_question = ""
    # Reload !
    reload(questions.modules[module_name])
    state.question = questions.questions[state.question.name]
    statistics.forget_stats()
    state.student.answerables_cache = None
    questions.sort_questions()

def _change_acl(state, acls):
    acl = state.form["value"]
    if acl[0] in ('+', 'Y'):
        v = True
    elif acl[0] == '-':
        v = False
    else:
        v = None
    acls[acl[1:]] = v
    acls.write()

    for s in statistics.question_stats().all_students:
        s.acls.action_menu_cached = None
        s.answerables_cache = None

def acl_change(state):
    _change_acl(state, state.student.acls)

def acl_change_other(state):
    _change_acl(state, state.student_stat.acls)

def acl_default_change(state):
    _change_acl(state, configuration.acls_default)
def role_student_change(state):
    _change_acl(state, configuration.acls_student)
def role_teacher_change(state):
    _change_acl(state, configuration.acls_teacher)
def role_author_change(state):
    _change_acl(state, configuration.acls_author)
def role_admin_change(state):
    _change_acl(state, configuration.acls_admin)

def role_teacher_i_have(state):
    state.student.acls.action_menu_cached = None
    state.student.answerables_cache = None
    state.student.acls.set_role(configuration.acls_teacher)

def role_student_i_have(state):
    state.student.acls.action_menu_cached = None
    state.student.answerables_cache = None
    state.student.acls.set_role(configuration.acls_student)

def role_author_i_have(state):
    state.student.acls.action_menu_cached = None
    state.student.answerables_cache = None
    state.student.acls.set_role(configuration.acls_author)

def role_admin_i_have(state):
    state.student.acls.action_menu_cached = None
    state.student.answerables_cache = None
    state.student.acls.set_role(configuration.acls_admin)
