# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

add(name="intro",
    required=["sh:console"],
    question="""Quel commande permet de changer les droits
    d'accs  des fichiers et rpertoires.""",
    tests=(
    good("chmod"),
    ),
    )

add(name="numrique",
    required=["intro"],
    question="""A quelle valeur numrique crite en octal correspond
    le mode <tt>rwxr-x---</tt>""",
    tests=(
    good("750"),
    require_int,
    ),
    indices=(
    """Remplacez les lettres par des 1 et les - par des zros.
    Convertissez le nombre binaire en octal (base 8) :
    <tt>101010011 = 101 010 011 = 523</tt>
    """,
    ),
    )

b = """De nombreuses rponses sont possibles.
Toutes ne sont pas acceptes.
Pour augmenter vos chances vous devez donnez la rponse la plus courte.
Si vous utilisez les modes 'r', 'w' et 'x' il faut qu'ils
soient utiliss de prfrence dans cet ordre."""

chmod_required = require("chmod", "Vous devez utiliser <tt>chmod</tt>")

add(name="simple",
    required=["numrique"],
    before=b,
    question="""Quel ligne de commande permet d'affecter
    le mode <tt>rwxr-xr-x</tt> au fichier <tt>essai.sh</tt>""",
    tests=(
    shell_good((
    "chmod 755 essai.sh",
    "chmod u=rwx,go=rx xxx essai.sh",
    "chmod a=rx,u+w essai.sh",
    )),
    chmod_required,
    require("essai.sh", "On veut modifier le mode de <tt>essai.sh</tt>"),
    require("755", "Vous vous tes tromp en calculant le mode"),
    shell_display,
    ),
    good_answer="""Le plus court est <tt>chmod 755 essai.sh</tt>""",
    indices=("""Rcrire la suite de lettre en remplaant les '-'
    par des '0' et les lettres par des '1' et convertir le nombre
    binaire en octal (base 8)""",),
    )


add(name="ajouter",
    required=["simple"],
    question="""Quel ligne de commande permet d'ajouter le droit
    d'excuter pour l'utilisateur au fichier <tt>essai.sh</tt>""",
    tests=(
    shell_good("chmod u+x essai.sh"),
    shell_good("chmod +x essai.sh",
               "Il est conseill de faire <tt>chmod u+x essai.sh</tt>"),
    shell_bad("chmod u+X essai.sh",
              """Le droit d'excution ne sera ajout que si
              <tt>essai.sh</tt> est un rpertoire"""),
    chmod_required,
    require("essai.sh",
            """Vous voulez changer le mode de <tt>essai.sh</tt>
            le minimum est de l'indiquer"""),
    require("+",
            """Vous ne voulez pas modifier compltement la valeur
            du mode mais seulement <b>ajouter</b> un droit
            suplmentaire"""),
    require("+x",
            """Vous voulez ajouter le droit d'excution,
            pas de faire autre chose"""),
    require("u+",
            """C'est seulement pour l'utilisateur que vous
            voulez ajouter le droit d'xcution"""),
    shell_display,
    ),
    indices=("""On ne connais pas l'ancien mode, on utilise donc
    la syntaxe <tt>[u][g][o][a][+|-][r][w][x]</tt>""",
             ),
    )

add(name="exec pattern",
    required=["ajouter", "pattern:0 au milieu"],
    before=b,
    question="""Quel ligne de commande permet <b>d'ajouter</b>
    le mode 'x' pour l'utilisateur, le groupe et les autres
     tous les fichiers du rpertoire courant dont
    le nom se termine par <tt>.sh</tt>,
    """,
    tests=(
    shell_good("chmod +x *.sh"),
    shell_good(("chmod u+x,g+x,o+x *.sh", "chmod ugo+x *.sh", ),
               "<tt>chmod a+x *.sh</tt> est plus court"),
    shell_bad("chmod o+x *.sh",
              "Cela n'a pas ajout le droit d'excution  l'utilisateur"),
    reject(";",
           "On ne veux utiliser <tt>chmod</tt> qu'une seule fois"),
    require("+",
            "Il faut indiquer que vous <b>ajoutez</b> des droits"),
    reject("find",
           """On veux changer les droits dans le rpertoire courant
           pas dans toute la hirarchie"""),
    reject("./*",
           "Le <tt>./</tt> ne sert  rien ici"),
    shell_display,
    ),
    )

add(name="exec pattern 2",
    required=["exec pattern"],
    before=b,
    question="""Quel ligne de commande permet <b>d'ajouter</b>
    le mode 'w' pour l'utilisateur, le groupe et les autres
     tous les fichiers du rpertoire courant dont
    le nom se termine par <tt>.sh</tt>,
    """,
    tests=(
    shell_good("chmod a+w *.sh"),
    shell_good(("chmod u+w,g+w,o+w *.sh", "chmod ugo+w *.sh", ),
               "<tt>chmod a+w *.sh</tt> est plus court"),
    shell_bad("chmod +w *.sh",
               """Cela ne l'ajoute qu' l'utilisateur"""),
    ),
    )


import chercher

add(name="rparation",
    required=["ajouter", "chercher:excuter", "chercher:images"],
    before="""Un administrateur maladroit  rendu tous vos fichiers
    excutables&nbsp;: les fichiers texte, les images, les pages HTML, ...""",
    question="""Quelle ligne de commande permet d'enlever le bit <tt>x</tt>
    des images PNG et JPG de votre compte.
    Il ne faudra pas tenir compte de la casse, et la solution
    la plus courte est recherche.
    (Dans votre rponse indiquez d'abord PNG puis JPG).
    """,
    tests=(
    shell_good(
    "find ~ \( -iname '*.png' -o -iname '*.jpg' \) -exec chmod -x {} \\;",
    dumb_replace=chercher.dumb_replace),
    shell_bad(
    "find ~ -iname '*.png' -o -iname '*.jpg' -exec chmod -x {} \\;",
    """Le <tt>-exec</tt> va s'excuter seulement pour les JPG
    pas pour les PNG. Vous devez parenthser""",
    dumb_replace=chercher.dumb_replace),
    require("find", "Il faut utiliser <tt>find</tt>"),
    require("~",
            """Vous devez changer tous les fichiers
             partir de la <b>racine de votre compte</b>"""),
    reject("ugo", "Utilisez <tt>a</tt> plutt que <tt>ugo</tt>"),
    reject("regex",
           "Utilisez <tt>-iname</tt> plutt qu'une expression rgulire"
           ),
    require("-o", "Il faut faire un 'ou', donc il vous faut un <tt>-o</tt>"),
    require(("(", ")"),
            """Il faut paranthser le 'ou' pour que le <tt>exec</tt>
            s'applique au deux"""),
    
    shell_display,
    ),
    indices=("Il faut utiliser la commande <tt>find</tt>",
             """On veut enlever le mode <tt>x</tt>  l'utilisateur,
             au groupe et aux autres.
             N'oubliez pas, la rponse doit tre la plus courte.""",
             ),
    )
