# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr

from questions import *
from check import *


add(name="message cod",
    required=["texte:remplace multiple"],
    question="""Vous recevez le message secret
    <tt>731 4251331 6135421 731 35421 61 42513 13 42531</tt>
    Pour le lire, il faut faire quelques remplacements&nbsp;:
    <ul>
    <li> 1 &#8594; e
    <li> 2 &#8594; h
    <li> 3 &#8594; n
    <li> 4 &#8594; c
    <li> 5 &#8594; i
    <li> 6 &#8594; d
    <li> 7 &#8594; u
    </ul>
    Fais afficher le message dcod.
    """,
    default_answer="print '731 4251331 6135421 731 35421 61 42513 13 42531'",
    tests=(
    do_not_cheat(rejected='chien'),
    print_required,
    replace_required,
    python_answer_good('une chienne deniche une niche de chien en chine\n'),
    python_display,
    ),
    )

add(name='10001 = ? * ?',
    required=['pour:d + d = 7'],
    question="""Fait afficher les deux nombres plus petits que 200 dont
    le produit est gal  <tt>10001</tt>.""",
    nr_lines = 4,
    tests=(
    do_not_cheat(rejected='137'),
    for_required,
    print_required,
    number_of_is('for', 2, "Il faut deux boucles pour trouver"),
    python_answer_good('73 137\n', remove_spaces=True, remove_newline=True),
    python_answer_good('137 73\n', remove_spaces=True, remove_newline=True),
    python_answer_good('73 137 137 73\n',
                       """Tu as trouv que
                       <tt>73 * 137 = 10001</tt>
                       et
                       <tt>137 * 73 = 10001</tt>
                       C'est un peu la mme chose... Non&nbsp;?
                       <p>
                       Pour viter cela, on affiche seulement le plus grand
                       nombre en premier.
                       C'est trs facile, il faut que la deuxime boucle
                       s'arrte avant de dpass la premire.
<pre>for d1 in range(200):
 for d2 in range(d1):
   if d1 * d2 == 10001:
     print d1, d2</pre>
     Cette boucle affiche <tt>137 73</tt>contrairement
      la tienne qui affiche&nbsp;:
     <hr>
     """,                       
                       remove_spaces=True, remove_newline=True),
    python_display,
    ),
    )

def pm(number, prod, summ, n):
    if n == 0:
        if prod == summ:
            print number
    else:
        n -= 1
        for i in range(1,number % 10 + 1):
            pm(number*10 + i, prod*i, summ+i, n)

# for i in range(1,10): pm(i, i, i, 2)

               
add(name="multiplier = sommer",
    required=['pour:d + d = 7'],
    question="""Fais afficher par Python le
    <b>plus grand</b> nombre de 3 chiffres qui 
    la particularit d'avoir la somme de ses 3 chiffres gale
    au produit de ses trois chiffres.
    <p>
    Avec 6 chiffres la solution  trouver serait <em>621111</em>
    car <em>6+2+1+1+1+1 = 12 = 6*2*1*1*1*1</em>.
    Tu devrais faire afficher  Python <tt>6 2 1 1 1 1</tt>.
    """,
    nr_lines = 6,
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    for_required,
    if_required,
    number_of_is('for', 3, "Il faut 3 <tt>for</tt> pour cet exercice"),
    python_answer_reject('1 2 3',
                 """Il faut une seule rponse pour cet exercice,
                 regarde les indices pour t'aider"""),
    range_required(),
    python_answer_good('321', remove_spaces=True, remove_newline=True),
    python_display,
    ),
    indices = (
    """Le plus grand nombre est celui qui a les plus gros chiffres
    au dbut.""",
    """Il faut 3 boucles imbriques&nbsp;:
    <ul>
    <li> La premire va de 1  9 car le premier chiffre ne peut tre 0.</li>
    <li> La deuxime va de 0 jusqu' la valeur du chiffre prcdent
    pour garantir que le premier sera le plus grand.</li>
    <li> La troisime va de 0 jusqu' la valeur du chiffre prcdent
    pour garantir que le deuxime sera le plus grand.</li>
    </ul>""",
    """Le dbut pour t'aider&nbsp;:
    <pre>for premier in range(1,10):
    for deuxieme in range(premier+1):</pre>
    """,
    ),
    )
    
