# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr

from questions import *
from check import *

add(name='intro',
    required=['nombre:addition multiple', 'classeur:multiplication',
              'texte:remplace multiple', 'pour:compter de 2 en 2'],
    before="""Quand quelque chose est vrai, Python l'crit
    <tt>True</tt> et si c'est faux, il crit <tt>False</tt>""",
    question="""Fait crire <tt>True</tt>  Python""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    require("True", "Je ne vois pas le <tt>True</tt>"),
    python_answer_good('True\n'),
    python_display,
    ),
    )

add(name='galit nombres',
    required=['intro', 'nombre:multiplication'],
    before="""Pour demander  Python si deux choses sont gales,
    on met l'opration <tt>==</tt> entre les deux choses.
    Par exemple <tt>print 5 == 7</tt> affiche <tt>False</tt>""",
    question="""Fait afficher  Python si <tt>123*456</tt>
    est gale  <tt>56088</tt>.""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    multiply_required,
    do_not_cheat(rejected='True'),
    require(('123', '*', '456'), "Tu dois faire calculer <tt>123*456</tt>"),
    egality_required,
    comment("""Les parenthses ne sont pas utiles car le Python
    calcule d'abord les multiplications, puis les additions et enfin
    il fait les comparaisons (<tt>==</tt> et les autres)""",
            require=(')','(')),
    python_answer_good('True\n'),
    python_display,
    ),
    )

add(name='galit textes',
    required=['galit nombres', 'texte:chien'],
    question="""Fait afficher  Python si <tt>'Bonjour'</tt>
    est gale  <tt>'bonjour'</tt>.""",
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    do_not_cheat(rejected='False'),
    require(("'Bonjour'", "'bonjour'"),
            "Tu dois comparer les textes <tt>Bonjour</tt> et <tt>bonjour</tt>"
            ),
    egality_required,
    python_answer_good('False\n'),
    python_display,
    ),
    )

good_search = """0 * 8 == 72 : False
1 * 8 == 72 : False
2 * 8 == 72 : False
3 * 8 == 72 : False
4 * 8 == 72 : False
5 * 8 == 72 : False
6 * 8 == 72 : False
7 * 8 == 72 : False
8 * 8 == 72 : False
9 * 8 == 72 : True
10 * 8 == 72 : False
11 * 8 == 72 : False
12 * 8 == 72 : False
13 * 8 == 72 : False
14 * 8 == 72 : False
"""

add(name="recherche 72",
    required=['galit nombres', 'dis:formule et rsultat',
              'pour:compter de 2 en 2'],
    question="""Fais afficher  Python :<pre>%s</pre>""" % good_search,
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    egality_required,
    for_required,
    range_required(15),
    do_not_cheat(rejected=('False', '10')),
    python_answer_good(good_search, remove_spaces=True),
    python_display,
    ),
    indices=(
    """Commence par faire une boucle affichant les nombres de 0  15,
    puis ajoute la formule, puis ajoute le test d'galit pour
    que Python affiche <tt>True</tt> ou <tt>False</tt>""",
    )
    )

add(name='galit trange',
    required=['galit textes'],
    question="""Fait afficher  Python si <tt>'True'</tt>
    et gale  <tt>True</tt>""",
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    egality_required,
    require('True',
            """Je ne trouve pas la texte <tt>'True'</tt> dans
             la phrase Python&nbsp;!"""
            ),
    do_not_cheat(rejected='False'),
    python_answer_good('False\n'),
    python_display,
    ),
    good_answer="""Pour Python le texte <tt>'True'</tt>
    et <tt>True</tt> ne sont pas gaux car le deuxime n'est pas un texte
    mais un boolen qui indique si quelque chose est vrai ou faux.""",
    )

    
add(name='infrieur nombre',
    required=['galit nombres'],
    before="""La phrase <tt>a &lt; b</tt> est vraie
    si <tt>a</tt> est plus petit que <tt>b</tt>.
    <p>
    <tt>a</tt> et <tt>b</tt> peuvent tre des nombres, des textes, ...""",
    question="""Fais afficher si <tt>2*3</tt> est infrieur  <tt>6</tt>""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    do_not_cheat(rejected='False'),
    require(('2','3','6','<','*'),
            "Dans la phrase Python on doit trouver&nbsp;: 2, 3, 6, *, &lt; et 6"
            ),
    less_than_required,
    python_answer_good('False\n'),
    python_display,
    ),
    good_answer = """Et oui, c'est faux car 6 n'est pas infrieur  6....""",
    )

add(name='infrieur texte',
    required=['infrieur nombre', 'galit textes'],
    before="""Un texte est infrieur (&lt;)  un autre s'il
    est avant lui dans le dictionnaire.""",
    question="""Fais afficher si <tt>'aprs'</tt> est infrieur  <tt>'avant'</tt>""",
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    do_not_cheat(rejected='True'),
    require(("'aprs'","'avant'", '<'),
            "Dans la phrase Python on doit trouver&nbsp;: 'aprs', 'avant' et &lt;"
            ),
    less_than_required,
    python_answer_good('True\n'),
    python_display,
    ),
    )

add(name='dans',
    required=['si:cherche', 'galit nombres'],
    before="""On a souvent besoin de savoir si quelque chose est
    dans un classeur. En franais, on dirait
    <em>truc est-il dans machin&nbsp;?</em>
    en Python on dit <tt>truc in machin</tt>
    On a pas besoin du point d'interrogation.
    """,
    question="""Fais crire  Python s'il trouve <tt>'a'</tt>
    dans le classeur <tt>'un grand chat'</tt>""",
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    in_required,
    do_not_cheat(rejected='True'),
    reject('for', """Il faut faire cet exercice sans boucle <tt>for</tt>"""),
    require(("'un grand chat'","'a'"),
            """Dans la phrase Python on doit trouver&nbsp;: 'un grand chat'
            et 'a'"""
            ),
    python_answer_good('True\n'),
    python_display,
    ),
    )
    
