# URL Of the Centralized Authentification service
CAS = 'https://cas.univ-lyon1.fr:8443/cas'

# If the student stays with a question displayed longer than this time,
# then we do not count the time as thinking time.
timeout_on_question = 1800 # In seconds

# ACLS that are given to everybody (stored in Students/portNumber/acls)
acl_default_see = """
action_help_see
stat_see
answered_see
action_deconnection
question_required_see
gui_times
question_see
question_answerable
action_comment_make
question_indice_see
"""

# Personnality can add or REMOVE acls by prefixing them by a '!'

student_role = """
question_shuffle
gui_smiley
gui_classement
"""

teacher_role = """
question_answerable_any
answered_see_other
answered_bad_see
answers_html_see
answered_comments_see
stat_questions_see
stat_others_csv_see
stat_others_see
stat_see_other
stat_same_time_see
answered_see_other
stat_histogram_good_see
stat_plot_see
role_student_i_have
"""

author_role = """
role_student_i_have,
question_answerable_any
question_display_any
answered_see_other
answers_html_see
answered_bad_see
answered_comments_see
stat_questions_see
answers_graph
stat_histogram_good_see
stat_histogram_level_see
question_next
question_answerable_anytime
answers_source_see
answers_reload
stat_plot_see
"""

admin_role = """
role_teacher_i_have
role_author_i_have
role_student_i_have
acl_see
acl_see_other
action_server_stop
action_server_start
acl_default_see
acl_change
acl_change_other
acl_default_change
role_admin_see
role_admin_change
role_author_see
role_author_change
role_student_see
role_student_change
role_teacher_see
role_teacher_change
!action_help_see
!stat_see
!answered_see
!question_required_see
!gui_times
!question_see
!question_answerable
!action_comment_make
!question_indice_see
"""


# Once per 1 hour, a new ticket is asked to CAS
timeout = 3600 # in secondes

# A prefix added before the location in the URL.
# It is useful only if you want to have a proxy.
# For example:
#    http://www710.univ-lyon1.fr/-quenlig-...
# Is redirected by the HTTP server to:
#    http://lirispaj.univ-lyon1.fr:9876/...
# With the following configuration on 'www710' HTTP server:
# RewriteEngine On
# RewriteRule ^/-quenlig-(.*) http://lirispaj.univ-lyon1.fr:9876/$1 [P]
prefix = "-quenlig-/"

# Statistics take some time to compute.
# We don't want to compute them every time, so they are cached some time.
statistics_cpu_allocation = 1 # % of time used to compute statistics

# For INPUT / TEXTAREA
nr_columns = 60




