# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *
import random

def end_by_dollar(a):
    return a and a[-1] == '$', ''

add(name="console",
    before="""Pour faire la suite de ce TP vous devrez taper des commandes
    shell ou bien dans une console texte accessible par Controle-Alt-F1
    ou bien dans un mulateur de terminal comme :
    <ul>
    <li> xterm (je recommande vivement celui-ci)
    <li> gnome-terminal
    <li> eterm
    </ul>
    <p>
    Vous pouvez lancer le terminal :
    <ul>
    <li>  partir d'un clique bouton droit sur le fond d'cran,
    <li> un clique bouton gauche sur un icone mulateur de terminal
    <li>  partir du menu contenant toutes les applications.
    </ul>
    <p>Je vous conseille de mettre le navigateur web cote  cote
    avec le terminal comme cela vous pouvez voir les 2 en mme
    temps et faire du copi coll.
    """,
    question="""
    Lancez un mulateur de terminal, quelle est la chane
    de caractre exacte qu'il y a  gauche du curseur&nbsp;?
    """,
    bad_answer = """Auriez-vous par hasard chang votre environnement
    pour qu'il affiche autre chose que le <em>prompt</em> standard
    en modifiant la variable <tt>PS1</tt> dans vos scripts <tt>.profile</tt>
    ou <tt>.bashrc</tt>&nbsp;?
    <p>
    Pour revenir au <em>prompt</em> standard, tapez EXACTEMENT :
    <pre>. /etc/profile</pre>
    """,
    good_answer = """Ce que vous venez de taper s'appel un <em>prompt</em>,
    il vous indique que le shell est prt  lire la commande que vous
    allez taper.""",
    indices=("""Cette chane se termine gnralement par un $ et un espace.""",),
    tests=(
    good("###$", "C'est le prompt par dfaut dans l'UFR informatique, le vrai prompt par dfaut est historiquement `$&nbsp;"),
    end_by_dollar,
    ),
    required = ["intro:final", "navigation:final"]
    )


casse = "Majuscule et minuscule sont diffrentes"


add(name="change rpertoire",
    question="""Quelle est la commande (builtin) permettant
    de changer de rpertoire courant&nbsp;?""",
    tests=(
    good("cd"),
    bad(("Cd", "CD"), casse)
    ),
    )

add(name="aller dans",
    question="""Quelle commande tapez-vous pour
    changer de rpertoire courant devienne <tt>/usr/bin</tt>&nbsp;?""",
    tests=(
    shell_good("cd /usr/bin"),
    require("/usr/bin",
            "Je ne vois pas l'endroit ou vous devez allez dans la commande"),
    ),
    )

add(name="rpertoire connexion",
    required=["aller dans", "navigation:rp. connexion"],
    question="""Quelle est la chane de caractre la plus
    courte reprsentant le fichier nomm <tt>a</tt> dans votre rpertoire
    de connexion&nbsp;?""",
    tests=(
    good("~/a"),
    bad("$HOME/a", "Il y a plus court"),
    require("~",
            """Je ne vois pas le symbole qui reprsente votre
            rpertoire de connexion"""),
    ),
    )

add(name="rpertoire courant",
    required=["rpertoire connexion", "navigation:ici"],
    question="""Quel que soit l'endroit ou vous vous trouvez
    dans le systme de fichier.
    Quelle est la chaine de caractres (toujours la mme)
    qui est un des noms du rpertoire dans lequel vous tes&nbsp;?""",
    tests=(
    good("."),
    good("./", "Accept, mais <tt>.</tt> est plus court"),
    bad(("~", "~/"), "Non, a c'est le rpertoire de connexion"),
    reject("pwd", "C'est une commande, pas un nom de fichier"),
    ),
    )

add(name="pre",
    required=["aller dans", "navigation:pre"],
    question="""Quelle commande tapez-vous pour
    changer de rpertoire courant afin que celui ci devienne
    le pre (le conteneur) du rpertoire courant actuel&nbsp;?""",
    tests=(
    shell_good("cd .."),
    shell_bad("cd",
              "Cette commande vous envois dans votre rpertoire de ocnnexion"),
    bad("..", "Ceci n'est pas un commande mais le nom du pre"),
    bad("cd..",
        """Vous auriez lanc cette commande vous auriez vu qu'elle
        affiche <em>cd.. : command not found</em>
        <p>
        Il faut sparer les arguments par des espaces."""),
    )
    )

add(name="directory courant",
    before="Changez votre rpertoire courant en tapant <tt>cd /usr/include</tt>",
    question="""Quelle est la commande la plus courte affichant
    sur la sortie standard (l'cran par dfaut)
    le texte qui suit&nbsp;:
    <pre>/usr/include</pre>""",
    tests=(
    good("pwd"),
    bad( ("PWD", "Pwd"), casse),
    reject("/usr/include",
           """Dans cet exercice,
           <tt>/usr/include</tt> est votre rpertoire courant,
           pas besoin de l'indiquer sur la ligne de commande
           pour l'afficher."""),
    ),
    indices=("C'est une commande ``builtin",
             "C'est l'abbrviation de <em>Print Working Directory</em>",
             ),
    )

def echo_text():
    c = "0123456789abcdefghijklmnopqrstuvwxyz"
    s = ""
    for a in range(40):
        s += c[random.randrange(len(c))]
    return s

def echo_simple_question():
    return "Quel est la ligne commande qui lorsque elle est ecute affiche :<pre>%s</pre>" % echo_text()

# Ne pas oublier que "check" retourne une fonction
def echo_simple_answer(answer):
    return shell_good("echo " + echo_text())(answer)

add(name="affiche paramtre",
    question=echo_simple_question,
    tests=(
    echo_simple_answer,
    bad("echo",
        """Quand vous tapez <tt>echo</tt> tout seul cela n'affiche pas
        la chaine de caractres demande mais une ligne vide."""),    
    shell_display,
    ),
    required=["console"],
    indices=("C'est une commande ``builtin",
             "Quand vous criez et qu'un instant aprs ce cri revient, c'est un ...",
             )
    )

add(name="affiche paramtres spciaux",
    question="""Quel commande permet d'afficher le texte suivant
    sur la sortie standard (l'cran)&nbsp;:
    <pre>avant    aprs</pre>""",
    tests=(
    shell_good("echo 'avant    aprs'"),
    shell_good( ( "echo avant \\ \\ \\ aprs",
                  "echo avant\\ \\ \\  aprs",
                  ), "Il est plus simple de tout mettre entre guillemets"
                ),
    require( ("avant", "aprs"), "Je ne vois pas les deux mots du texte !"),
    shell_require("avant    aprs",
                  """Dbouchez-vous les yeux,
                  il y a 4 espaces entre les deux mots.
                  C'est a la difficult"""),
    shell_display,
    ),
    bad_answer="""
    Attention, il y a quatre espaces entre les deux mots.
    Comme la commande 'echo' ne voit que les paramtres et pas
    leur sparateur elle affiche simplement un blanc
    entre les paramtres, alors qu'il y en a quatre.
    """,
    required=["affiche paramtre", "intro:guillemet"],
    )

add(name="affiche toile",
    question="""Quel commande permet d'afficher le texte suivant
    sur la sortie standard (l'cran)&nbsp;:
    <pre>*</pre>""",
    tests=(
    shell_good("echo '*'"),
    shell_bad("echo *",
              """Essayez la commande que vous avez indiqu,
              cela ne va pas afficher une toile..."""),
    shell_display,
    ),
    bad_answer="""
    L'toile est spciale, elle reprsente une suite de caractres
    quelconques.
    """,
    )

add(name="redirection entre",
    question="""Quel est le caractre indiquant que l'on redirige l'entre
    standard d'une commande pour qu'elle lise le contenu d'un fichier""",
    tests=(
    good("<"),
    bad(">",
        """Si vous utilisez celui-ci,
        vous perdez le fichier que vous vouliez lire"""),
    ),
    required=["console"],
    )

add(name="redirection sortie",
    question="""Quel est le caractre indiquant que l'on redirige la sortie
    standard d'une commande dans un fichier en le vidant d'abord""",
    tests=(
    good(">"),
    ),
    required=["redirection entre"],
    good_answer="""Ce caractre est extremement dangereux car il vide
    le contenu du fichier sans possibilit de rcupration.
    Il ne faut pas le confondre avec la redirection de l'entre standard.
    """
    )

add(name="redirection erreur",
    question="""Quel est la chane de caractres indiquant
    que l'on redirige la sortie d'erreur d'une commande dans un fichier
    en le vidant d'abord""",
    tests=(
    good("2>"),
    bad(">", "Vous redirigez la sortie standard, pas la sortie d'erreur"),
    bad("2 >",
        """Comme les deux caractres ne sont pas colls,
        le shell croit qu'il y a un paramtre qui a comme valeur <tt>2</tt>
        qui est suivi par une redirection de la sortie standard."""),
    require("2", "La sortie d'erreur porte le numro 2 (<em>fildes</em>)"),
    ),
    )

blanc = "Pour des raisons de lisibilit on met un espace avant le <tt>&lt;</tt> et le <tt>&gt;</tt>"

add(name="'Bonjour' dans 'toto'",
    question="""Quel est la ligne de commande la plus simple (courte)
    permettant de stocker
    le mot <tt>Bonjour</tt> dans le fichier <tt>toto</tt>.""",
    tests=(
    shell_good("echo Bonjour >toto"),
    shell_good("echo -n Bonjour >toto", "Vous tes perfectionniste :-)"),
    require("echo",
            """Il faut utiliser la commande qui crit ses paramtres
            sur la sortie standard et rediriger celle-ci sur le fichier"""),
    reject("<",
           """Si vous mlanger le <tt>&gt;</tt> et le <tt>&lt;</tt>
           vous risquez de perdre beaucoup de fichiers dans l'avenir"""),
    require(">", "Ou la redirection de la sortie standard ?"),
    require("Bonjour",
            """Ce que vous devez crire dans le fichier n'apparat
            mme pas dans la commande !"""),    
    shell_display,
    ),
    required=["affiche paramtre", "redirection sortie"],
    )

add(name="ajout en fin",
    required=["redirection sortie"],
    question="""Quelle suite de caractres utilise-t-on pour
    indiquer que l'on veut rediriger la sortie standard
    vers un fichier sans le vider (en ajoutant  la fin)&nbsp;?""",
    tests=(
    good(">>"),
    ),
    )

add(name="rebonjour",
    required=["'Bonjour' dans 'toto'", "ajout en fin", "paginer:navigation",],
    question="""Vous avez utilis <tt>echo</tt> pour mettre <tt>bonjour</tt>
    dans le fichier <tt>toto</tt>.
    Donnez la commande pour ajouter <tt>Salut</tt>
     la fin du fichier <tt>toto</tt>""",
    tests=(
    shell_good("echo Salut >>toto"),
    require(">>",
            """Ou est l'oprateur indiquant que vous voulez
            ajouter  la fin&nbsp;?"""),
    reject("salut", "On vous dit de mettre une majuscule  <tt>Salut</tt>."),
    shell_display,
    ),
    )

add(name="echo fin",
    required=["rebonjour", "concatener:intro"],
    before="""Faites&nbsp;:
    <pre>echo a &gt;toto
echo b &gt;&gt;toto</pre>""",
    question="""Que contient le fichier <tt>toto</tt>&nbsp;?
    vous pouvez utiliser la commande <tt>cat</tt> pour
    regarder le contenu.
    """,
    tests=(
    good("a\nb",
         """En effet, la commande <tt>echo</tt>
         ajoute automatiquement une fin de ligne"""),
    reject("ab", "Vous n'avez pas essay !"),
    ),
    nr_lines=4,
    )

add(name="remplacement",
    required=["lister:nomm", "pattern:tout", "variable:affectation"],
    question="""Donner la ligne de commande permettant
    de stocker la liste des noms des fichiers et rpertoires
    courant dans la variable <tt>A</tt>.""",
    tests=(
    shell_good(("A=$(echo *)", 'A="$(echo *)"')),
    shell_good(("A=$(ls)", 'A="$(ls)"'),
               """On prfere utiliser <tt>echo</tt>
               car c'est une <em>builtin</em>,
               la rponse recommende est <tt>A=$(echo *)</tt>"""),
    require("=",
            "Pour mettre la valeur dans la variable on fait une affectation"),
    shell_bad("A=ls",
              """Vous venez de mettre la chaine de caractre <tt>ls</tt>
              dans la variable <tt>A</tt>"""),
    shell_require('</replacement>',
                  """Je ne vois pas la syntaxe permettant de remplacer
                  une commande par ce qu'elle affiche.
                  Rappelez-vous, c'est <tt>$(<em>une commande</em>)</tt>
                  """),
    reject("export", "On ne vous a pas demand d'exporter la variable"),
    shell_display,
    ),
    indices=('''On utilise la syntaxe shell permettant de remplacer
    une commande par la sortie standard de celle-ci.''',
             
             ),
    )

add(name="deuxime mot",
    required=["remplacement", "variable:lire mots", "regroupement 2",
              "date:intro"],
    question="""Donnez la commande stockant le deuxime
    mot affich par la commande <tt>date</tt> dans la
    variable <tt>Z</tt>.
    <p>
    Si vous avez besoin de variables, appelez les <tt>A</tt>, <tt>B</tt>, ...
    """,
    tests=(
    shell_good("Z=$(date | (read A B C ; echo $B))"),
    shell_bad("Z=$(date | (read A B ; echo $B))", "Vous n'avez pas essay"),
    shell_good("Z=$(date | cut -d' ' -f2)",
               """J'attendais <tt>read</tt> et <tt>echo</tt>,
               mais votre rponse fonctionne"""),
    ),
    )


add(name="excution squencielle",
    required=["console", "lister:intro", "directory courant",
              "intro:esperluette"],
    question="""Quel caractre (autre que le retour  la ligne)
    indique que deux commandes
    doivent s'excuter l'une aprs l'autre.
    Mme si la premire s'est mal pass""",
    tests=(
    good(";"),
    ),
    indices=(
    "Ce caractre est utilis pour sparer deux commandes sur la mme ligne",
    ),
    )

add(name="squencielle",
    question="""Donnez la ligne compose d'un suite de commandes
    qui dans l'ordre&nbsp;:
    <ul>
    <li> Change le rpertoire courant afin d'aller dans le rpertoire <tt>toto</tt> (qui est dans le rpertoire courant)
    <li> Affiche la liste des noms de fichier.
    <li> Change le rpertoire courant pour aller dans le pre, c'est-a--dire
    revenir dans le rpertoire initial.
    </ul>
    <p>
    Si une commande choue, les suivantes doivent s'excuter.
    """,
    tests=(
    shell_good("cd toto ; ls ; cd .."),
    shell_bad("cd toto && ls && cd ..",
              """Votre commande est <b>correcte</b>, mais elle en fait plus
              que ncessaire car elle est fiable.
              C'est la rponse  une futur question.
              Donnez la rponse non fiable."""),               
    shell_require("<command><argument>cd</argument><argument>toto</argument></command>",
                  "On veut aller dans le rpertoire <tt>toto</tt>"),
    shell_require("<command><argument>ls</argument></command>",
                  "On veut lister les fichiers, on utilisera <tt>ls</tt>"),
    shell_require("<command><argument>cd</argument><argument>..</argument></command>",
                  "On veut remonter dans le pre."),
    ),
    good_answer="""Cette suite de commandes est dangereuse  utiliser.
    En effet le rpertoire courant aprs son excution a pu changer
    si le <tt>cd toto</tt> n'est pas accessible.""",
    )

add(name="regroupement",
    required=["squencielle", "redirection sortie", "date:intro",
              "concatener:concatener"],
    before="""Les parenthses permettent de regrouper des commandes
    ensemble pour qu'elles s'excutent dans le mme shell
    et que l'on puisse rediriger les entres/sorties sur l'ensemble
    des commandes""",
    question="""Donnez la commande permettant de stocker
    dans le fichier <tt>xxx</tt> (en l'effaant) la date suivie du contenu
    du fichier <tt>/etc/passwd</tt>""",
    tests=(
    shell_good(("(date;cat /etc/passwd) >xxx",
                "(date;cat </etc/passwd) >xxx",
                )),
    reject(">>",
           """On veut remplacer le contenu du fichier <tt>xxx</tt>,
           pas ajouter  la fin."""),
           
    require("/etc/passwd", "Et <tt>/etc/passwd</tt>, ou est-il&nbsp;?"),
    require("date", "Et la date&nbsp;?"),
    require("cat", "Utilisez <tt>cat</tt> pour lire <tt>/etc/passwd</tt>"),
    require("xxx", "Vous avez oubli de dire dans quoi vous stockiez le rsultat"),
    ),
    )

add(name="regroupement 2",
    required=["regroupement", "variable:lire ligne", "variable:intro"],
    question="""Donnez la commande permettant d'afficher
    la deuxime ligne du fichier <tt>/etc/passwd</tt>
    sans utiliser les commandes <tt>head</tt> et <tt>tail</tt>
    <p>
    Si vous avez besoin d'une variable, appelez-la <tt>A</tt>.
    """,
    tests=(
    shell_good(("(read A ; read A ; echo $A ) </etc/passwd",
                "(read ; read A ; echo $A ) </etc/passwd"),
               "Des guillemets autour de <tt>$A</tt> sont prfrables"),
    shell_good(('(read A ; read A ; echo "$A" ) </etc/passwd',
                '(read ; read A ; echo "$A" ) </etc/passwd')
                ),
    ),
    indices=("On a seulement besoin de <tt>read</tt> et <tt>echo</tt>",
             ),
    )

    

add(name="squencielle fiable",
    question="""Quelle suite de caractres
    indique que la commande qui suit ne s'excute que
    si la commande prcdente c'est termine sans erreur&nbsp;?""",
    tests=(
    good("&&"),
    ),
    indices=("C'est dans votre cours...",),
    )

add(name="fiable",
    question="""Donnez la ligne compose d'un suite de commandes
    qui dans l'ordre&nbsp;:
    <ul>
    <li> Change le rpertoire courant afin d'aller dans le rpertoire <tt>toto</tt>
    <li> Affiche la liste des noms de fichier.
    <li> Change le rpertoire courant pour aller dans le pre.
    </ul>
    <b>Elle doit tre crite de manire  garantir
    que le rpertoire courant n'aura pas
    chang aprs son excution,
    et donc que l'on ne va pas dans le pre si l'on a pas
    pu aller dans <tt>toto</tt>.</b>
    """,
    tests=(
    shell_good("cd toto && ls && cd .."),
    require("&&",
            """Ou est l'oprateur indiquant que l'on ne veut excuter
            la commande suivante que si la prcdente
            c'est bien passe&nbsp;?"""),
    reject(";",
           """Quand vous utilisez <tt>;</tt> la commande suivante
           s'excute mme si celle d'avant n'a pas fonctionne"""),
    shell_display,
    ),
    )

add(name="boucle",
    required=["affiche paramtres spciaux", "variable:intro"],
    before="""La rponse  cette question a peu d'utilit,
    c'est seulement pour vrifier que vous savez faire une boucle <tt>for</tt>
    """,
    question="""Donnez la ligne de commande avec une boucle <tt>for</tt>
    affichant avec plusieurs appels  la commande <tt>echo</tt>&nbsp;:
    <pre>Un
Mot
Par
Ligne</pre>
<p>
Vous utiliserez <tt>I</tt> comme variable de boucle.
""",
    tests=(
    shell_good("for I in Un Mot Par Ligne ; do echo $I ; done",
               """Par scurit on met des guillemets
               autour du <tt>$I</tt>.
               Pensez au cas ou <tt>I</tt> contient une chaine
               de caractres avec des espaces."""
               ),
    shell_good('for I in Un Mot Par Ligne ; do echo "$I" ; done'),
    shell_bad("for I in Un Mot Par Ligne ; do echo '$I' ; done",
              "Vous n'avez mme pas essay la commande"),
    reject(" i ", "Un <tt>i</tt> MAJUSCULE comme on vous l'a demand"),
    require("Un Mot Par Ligne",
            "Je ne trouve pas l'ensemble de mots  itrer"),
    shell_require(">I</variable>",
                  "Je ne vois pas d'accs au contenu de <tt>I</tt>"),
    shell_display,
    ),
    )

add(name="arrire plan",
    required=["intro:esperluette", "console"],
    before="""Vous voulez lancer une fentre avec une horloge analogique.
    Vous faites par exemple&nbsp;:
    <pre><b>mon prompt$</b> xclock</pre>
L'horloge apparat mais votre invite de commande (<em>prompt</em>)
ne rapparat pas car le processus n'est pas encore termin.
<p>
Si vous tapez <tt>^C</tt> ou si vous fermez la fentre le processus
<tt>xclock</tt> va mourir et la fentre va se fermer.
""",
    question="""Comment lancer <tt>xclock</tt> en ligne de commande
    pour que l'invite de commande revienne tout de suite&nbsp;?""",
    tests=(
    shell_good("xclock &"),
    require("xclock",
            "C'est <tt>xclock</tt> que je veux lancer en arrire plan"),
    shell_display,
    ),
    indices=("""Il faut lancer le programme en arrire plan
    (tache de fond, ou en <em>background</em> en anglais""",
             ),
    )

