# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

#    nr_lines=10,
# puis clique sur le bouton <em>Envoyer la rponse</em>
#    pour que le Python puisse
#    lire ce que tu as crit

# Classeur d'un lment
# Classeru vide
# range(10)+[1]
# Losange ?
# Table addition/multiplication ?

from questions import *

import os
import sys

f = os.popen('sudo -u nobody echo ok', 'r')
if f.read() != 'ok\n':
    sys.stderr.write("""Please use the command 'visudo' to add the line:
exco ALL=(nobody) NOPASSWD: ALL
""")
    sys.exit(1)
f.close()


global_evals = {}

def python_eval(v):
    """Eval a python with a cache"""
    if global_evals.has_key(v):
        return global_evals[v]
    
    f = open("xxx.py", "w")
    f.write("""# -*- coding: latin-1 -*-\n""")
    f.write(v)
    f.close()
    # sudo :                              exco ALL=(nobody) NOPASSWD: ALL
    f = os.popen('sudo -u nobody python xxx.py 2>&1', 'r')
    displayed = f.read()
    f.close()

    global_evals[v] = displayed

    return displayed

def python_answer(v, comment):
    if comment:
        comment = comment + "</p><p>"
    return comment + "Le Python rpond : <pre>" + v + '</pre>'
    
def python_answer_good(v, comment=""):
    def pag(answer, get_answer=False):
        if get_answer:
            return get_answer_html('test_good test_is test_python', (v,), comment)
        a = python_eval(answer)
        if a == v:
            return True, python_answer(a, comment)
        else:
            return None, ""
    return pag

def python_answer_bad(v, comment=""):
    def pag(answer, get_answer=False):
        if get_answer:
            return get_answer_html('test_bad test_is test_python', (v,), comment)
        a = python_eval(answer)
        if a == v:
            return False, python_answer(a, comment)
        else:
            return None, ""
    return pag

def python_display(answer):
        return None, "Le Python rpond : <pre>" +python_eval(answer)+ '</pre>'


print_required = require(
    "print",
    """Il faut utiliser le mot <tt>print</tt> pour lui dire
    <em>dis-moi</em> sinon il ne te dira rien""")

apostrophe_required = require(
    "'",
    """Il faut mettre des apostrophes autour de ce que tu veux faire
    rpter au Python""")

apostrophe_rejected = reject(
    "'",
    """Il ne faut pas mettre des apostrophes autour des nombres
    et des oprations, sinon Python ne les comprend pas""")

space_required = require(
    " ",
    """Le Python est comme toi, pour qu'il comprenne une phrase
    forme de mot, il prfre que les mots soient spars les
    uns de autres par un espace.""")

plus_required = require(
    '+',
    "Tu as oubli le '+' pour faire l'addition")

multiply_required = require(
    '*',
    "Tu as oubli le '*' pour faire la multiplication")

comma_required = require(
    ',',
    "Tu as oubli la virgule qui veut dire <em>et</em>")

comma_rejected = reject(
    ',',
    "On a pas besoin de la virgule pour rpondre  cet exercice.")

lf_required = require(
    '\\n',
    "Tu as oubli un <tt>\\n</tt> pour lui dire de revenir  la ligne.")

bracket_required = require(
    ('(', ')'),
    """Tu as oubli de mettre des parenthses pour que
    le Python calcule dans le bon ordre.""")

square_bracket_required = require(
    ('[', ']'),
    """Tu as oubli de mettre des crochets <tt>[</tt>
    et <tt>]</tt> pour indiquer le devant et l'arrire de
    la couverture du classeur.""")

for_required = require(
    ('for', 'in', ':'),
    """Pour feuilleter un classeur, il faut respecter la phrase&nbsp;:<br>
    <tt>for page in classeur:</tt>
    """)
                        

add(name='bonjour',
    before="""
    <p>
    Tu sais calculer les additions et les multiplications,
    alors tu peux apprendre la langue du Python.
    Tu cris dans sa langue et il te rpond
    s'il te comprend.
    <p>
    Malheureusement le Python ne fait que ce qu'on lui
    demande et rien de plus.
    Par exemple, si tu lui dis <em>Bonjour</em>
    il ne te rpondra pas.
    Par contre tu peux lui dire&nbsp;:
    <em>Dis-moi 'Bonjour'</em>.
    <p>
    Dans la langue du Python, <em>Dis-moi</em> s'crit
    <tt>print</tt>.
    """,
    question="""Dans le cadre blanc,
    cris la phrase Python pour qu'il te dise <em>Bonjour</em>
    puis tape sur la touche <u>Return</u> ou <u>Entre</u>.
    """,
    good_answer="""Tu as remarqu que le Python t'a dis <tt>Bonjour</tt>
    sans mettre les apostrophes autour.""",
    indices=(
    """Tu dois remplacer dans la phrase <em>Dis-moi 'Bonjour'</em>&nbsp;:<br>
    <em>Dis-moi</em> par <tt>print</tt> pour que le Python comprenne.""",
    ),
    tests=(
    print_required,
    require("onjour",
            """Tu veux qu'il te rponde <em>Bonjour</em>,
            il faut donc que tu lui dises de dire <em>Bonjour</em>."""),
    apostrophe_required,
    python_answer_good('bonjour\n'),
    python_answer_good('Bonjour\n'),
    python_display,
    ),
    )

add(name='chien',
    required = ['bonjour'],
    question="""Dans le cadre blanc,
    cris la phrase Python pour qu'il crive <em>chien</em>
    puis tape sur la touche <u>Return</u> ou <u>Entre</u>.
    """,
    tests=(
    print_required,
    require("chien",
            """Tu veux qu'il crive <em>chien</em>,
            il faut donc que tu lui dises d'crire <em>chien</em>."""),
    apostrophe_required,
    python_answer_good('chien\n'),
    python_display,
    ),
    )
    
add(name='un chat',
    required = ['chien'],
    question="Fais dire <em>un chat</em>  Python.",
    tests=(
    print_required,
    require("un chat",
            """Tu veux qu'il crive <em>un chat</em>,
            il faut donc que tu lui dises d'crire <em>un chat</em>."""),
    apostrophe_required,
    python_answer_good('un chat\n'),
    python_display,
    ),
    )

add(name=' la ligne',
    required = ['chien'],
    before="""Quand tu veux que le Python revienne  gauche
    quand il crit quelque chose, il faut mettre '\\n'.
    Ces deux caractres lui indique qu'il ne faut pas continuer
     crire vers la droite.""",
    question="""Dis au Python d'crire '12' en revenant  la ligne
    entre le 1 et le 2.""",
    tests=(
    print_required,
    apostrophe_required,
    lf_required,
    require(('1', '2'), 'Ou sont le 1 et le 2&nbsp;?'),
    reject("'\\n'", 'On met entre les apostrophes le 1 et le \\n et le 2'),
    python_answer_good('1\n2\n'),
    python_display,
    ),
    )

add(name='nombre',
    required = ['un chat'],
    before="""Le Python comprend les nombres comme tu les cris habituellement,
    mais attention si tu met des apostrophes autour du nombre pour
    lui cela ne sera pas un nombre.""",
    question="""Fais crire <em>18</em>  Python""",
    tests=(
    print_required,
    require("18",
            """Tu veux qu'il crive <em>18</em>,
            il faut donc que tu lui dises d'crire <em>18</em>."""),
    space_required,
    apostrophe_rejected,
    python_answer_good('18\n'),
    python_display,
    ),
    )

before_operation = """Le Python sait faire les 4 oprations sur les entiers.
Il suffit d'crire ce que tu veux lui faire calculer et il le fait."""

add(name='addition',
    required = ['nombre'],
    before=before_operation,
    question="""Fais crire  Python le rsultat de l'opration 2 + 3""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    plus_required,
    require(('2', '3'),
            """Comment lui faire calculer 2 + 3 si dans la phrase que
            tu lui dis il n'y a pas 2 et 3&nbsp;?"""),
    python_answer_good('5\n'),
    python_display,
    ),
    )

add(name='addition norme',
    required = ['addition'],
    question="""Fais crire  Python le rsultat de l'addition
    de 123456789 et 987654321""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    plus_required,
    python_answer_good('1111111110\n'),
    python_display,
    ),
    )

add(name='addition multiple',
    required = ['addition'],
    question="Fais crire  Python le rsultat de l'addition de 1 et 2 et 3",
    tests=(
    print_required,
    space_required,
    plus_required,
    apostrophe_rejected,
    python_answer_good('6\n'),
    python_display,
    ),
    indices=(
    "Tu dois lui faire crire le rsultat de 1 + 2 + 3",
    ),
    )

add(name='soustraction',
    required = ['nombre'],
    before=before_operation,
    question="""Fais crire  Python le rsultat de l'opration 3 - 2""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    require(('-', '2', '3'),
            """Comment lui faire calculer 3 - 2 si dans la phrase que
            tu lui dis il n'y a pas 3 et - et 2&nbsp;?"""),
    python_answer_good('1\n'),
    python_display,
    ),
    )

add(name='soustraction norme',
    required = ['soustraction'],
    before="""J'ai un sac de 1000 bonbons, j'en donne 1.
    Combien m'en reste-t-il&nbsp;?
    """,
    question="""Fais afficher  Python le rsultat de la soustraction
    1000 moins 1.""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    require(('-', '1000', '1'),
            """Comment lui faire calculer 1000 - 1 si dans la phrase que
            tu lui dis il n'y a pas 1000 et - et 1&nbsp;?"""),
    python_answer_good('999\n'),
    python_display,
    ),
    )

add(name='multiplication',
    required = ['nombre'],
    before=before_operation,
    question="""Fais crire  Python le rsultat de l'opration 2 * 3""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    require(('*', '2', '3'),
            """Comment lui faire calculer 3 * 2 si dans la phrase que
            tu lui dis il n'y a pas 3 et * et 2&nbsp;?"""),
    python_answer_good('6\n'),
    python_display,
    ),
    )

add(name='print multiple',
    required = ['un chat', 'nombre'],
    before="""Quand on veut dire <em>et</em> comme dans la phrase
    <em>un chat et un chien</em> on remplace le mot
    <em>et</em> par une virgule pour que le Python comprenne""",
    question="Dis  python d'crire <em>5 et 'bonbons'</em>.",
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    comma_required,
    require(('5', 'bonbons'),
            """Comment lui faire afficher <em>5</em> et
            <em>'bonbons'</em> si tu ne lui dis pas
            ces 2 choses."""),
    reject('5 bonbons',
           """<tt>print '5 bonbons'</tt> fait bien afficher ce que
           l'on veut  Python, mais on veut lui faire afficher
           <em>5</em> et <em>'bonbons'</em> et non <em>'5 bonbons'</em>.
           Dans un cas on lui dis d'afficher 2 choses et dans
           l'autre une seule.
           """
           ),
    python_answer_good('5 bonbons\n'),
    python_display,
    ),
    indices=(
    "Il faut traduire en Python&nbsp;: <em>Dis-moi 5 et 'bonbons'</em>",
    ),
    good_answer="""Tu as remarqu que le Python a mis un espace
    entre <em>5</em> et <em>bonbons</em>&nbsp;?""",
    )

add(name='formule et rsultat',
    required = ['print multiple', 'addition'],
    question= "Traduis en Python&nbsp;: <em>Dis-moi 1 et '+' et 1 et '=' et 1+1</em>",
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    comma_required,
    reject('2',
           """On ne veut pas que tu dises  Python de donner la solution,
           on veut que le python la calcule tout seul.
           Tu ne dois pas lui dire que la solution est 2.
           """),
    reject("'1+1'",
           """Si tu met des apostrophes autour de <em>1+1</em> il va
           afficher <tt>1+1</tt> au lieu de faire le calcul."""),
    python_answer_good('1 + 1 = 2\n'),
    python_display,
    ),
    indices=(
    """Il faut faire comme dans les questions prcdentes.
    Remplacer <em>Dis-moi</em> par <tt>print</tt> et les <em>et</em>
    par des virgules""",
    )
    )

add(name='addition texte',
    required=['addition'],
    before="""Le Python permet d'ajouter autre chose que des nombres.
    L'addition permet de coller ensemble deux textes.""",
    question="Dis au Python d'afficher 'Le' + 'chien'",
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    plus_required,
    comma_rejected,
    python_answer_good('Lechien\n'),
    python_answer_good('lechien\n'),
    python_display,
    ),
    good_answer="""Quand on demande  Python de coller ensemble
    deux textes, il ne met pas un espace entre les deux.""",
    )
    
add(name='multiplication texte',
    required=['addition texte', 'multiplication'],
    before="""La multiplication indique que l'on rpte quelque chose.
    2*3 veut dire que l'on rpte&nbsp;:
    <ul>
    <li> 2 additions de 3 : 3 + 3 = 6</li>
    <li> 3 additions de 2 : 2 + 2 + 2 = 6</li>
    </ul>
    <p>
    Donc 3*'coucou' veut dire 'coucou' + 'coucou' + 'coucou' = 'coucoucoucoucoucou'
    """,
    question="Dis  Python d'afficher 10 fois 'chien '",
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    multiply_required,
    comma_rejected,
    python_answer_good('chien '*10 + '\n'),
    python_answer_good(' chien'*10 + '\n'),
    python_answer_bad('chien'*10 + '\n',
                      "Tous les mots sont colls, ajoute un espace  la fin de chien !"),
    python_display,
    ),
    )

square_star = """*****
*****
*****
*****
*****

"""

add(name='carr toil',
    required=['multiplication texte', ' la ligne'],
    before="Le carr toil :<pre>" + square_star + "</pre>",
    question="""Pour afficher un carr toil, dis  Python
    d'afficher 5 fois le texte : ***** suivies d'un retour  la ligne.""",
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    multiply_required,
    comma_rejected,
    lf_required,
    python_answer_good(square_star),
    require('*****', 'Je ne trouve pas les ***** que tu dois afficher'),
    python_display,
    ),    
    )

add(name='ordre des calculs',
    required=['addition multiple', 'multiplication', 'soustraction norme'],
    before="""Tu as 3 paquets de bonbons contenant 2 bonbons
    rouges et 1 bonbon bleu.
    <ul>
    <li> Chaque paquet contient donc 2+1 bonbons.
    <li> Comme tu as 3 paquets, tu possdes donc 3 fois 2+1 bonbons.
    <li> Donc 3 fois 3 bonbons.
    <li> Tu as 9 bonbons.
    </ul>
    <p>
    Si tu dis au Python de calculer 3 * 2+1 il va d'abord faire
    3*2 et trouver 6, puis 6+1 et trouver 7. CATASTROPHE.
    <p>
    Pour que le python fasse les calculs dans le bon ordre
    il faut mettre des parenthses&nbsp;:
    <p>
    <tt>3 * ( 2 + 1 )</tt>
    """,
    question="""Dans chacune des trousses de la classe
    il y a 2 feutres bleus et 3 rouges.
    Fait calculer  Python le nombre de feutres
    que l'on trouverais si l'on vidait les 10 trousses de la classe""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    multiply_required,
    plus_required,
    comma_rejected,
    bracket_required,
    python_answer_good("50\n"),
    python_display,
    ),    
    )

add(name='classeur',
    required=['multiplication', 'addition'],
    before="""De la mme faon que tu ranges des pages dans des classeurs
    Python peut faire de mme.
    Un classeur est constitu par&nbsp;:
    <ul>
    <li> le devant de sa couverture,
    <li> une premire page
    <li> et une deuxime page
    <li> et une troisime page
    <li> ...
    <li> et la dernire page
    <li> l'arrire de la couverture.
    </ul>
    <p>
    On traduit cela en Python&nbsp;:
    <ul>
    <li> On indique le devant de la couverture par <tt>[</tt>
    <li>  la place des pages tu peux mettre tout ce que
    le python comprend&nbsp;: textes, nombres, ...
    <li> Le <em>et</em> s'crit virgule comme d'habitude
    <li> L'arrire de la couverture s'crit <tt>]</tt>
    </ul>
    <p>
    Voici un classeur&nbsp;:
    <tt>[3, 'chien', 5, 'chat', 2*5]</tt>
    """,
    question="""Dis  Python d'afficher le classeur contenant
    6 et 1+1 et 'toto'""",
    tests=(
    print_required,
    space_required,
    plus_required,
    comma_required,
    square_bracket_required,
    python_answer_good("[6, 2, 'toto']\n"),
    python_display,
    ),
    good_answer="""Tu remarqueras que le 1+1 est devenu 2&nbsp;!<br>
    Python effectue les calculs quand il fabrique son classeur.""",
    )

add(name='les entiers',
    required=['classeur'],
    before="""Le Python sait compter, il suffit de lui demander.
    Tu lui dis <tt>range(4)</tt> et il rpond <tt>[0, 1, 2, 3]</tt>.
    <p>
    Il te fabrique un classeur contenant les nombres
    les uns aprs les autres.""",
    question="""Dis  Python d'afficher un classeur contenant
    les nombres de 0  19 (sans le 20)""",
    tests=(
    print_required,
    space_required,
    bracket_required,
    require("range", "Tu dois utiliser <tt>range</tt>"),
    reject('19', "Il va aller jusqu' 18, pas 19."),
    python_answer_good(str(range(20))+'\n'),
    python_display,
    ),
    )
    

add(name="classeur dans classeur",
    required=['classeur'],
    question="""Dis  Python d'afficher un classeur contenant
    deux classeurs, le premier contient 'chien' et 4
    le deuxime contient 'rouge' et 'homme' et 2.""",
    tests=(
    print_required,
    space_required,
    comma_required,
    square_bracket_required,
    apostrophe_required,
    number_of_is('[',3,
                 """Il doit y avoir 3 devants de couvertures de classeur
                 car il y a un gros classeur et deux petits"""),
    number_of_is(']',3,
                 """Il doit y avoir 3 derrires de couvertures de classeur
                 car il y a un gros classeur et deux petits"""),    
    number_of_is(',',3,
                 """Il doit y avoir 3 virgules car il y a 3 <em>et</em>&nbsp;:
                 <ul>
                 <li> 'chien' ET 4
                 <li> premier petit classeur ET deuxime petit classeur
                 <li> 'homme' ET 2
                 </ul>"""),
    require(("'chien'", "'homme'", '4', '2'),
            """Tu dois dire  Python qu'il y a 'chien', 'homme', 4, 2
            dans les classeurs"""),
    python_answer_good("[['chien', 4], ['homme', 2]]\n"),
    python_display,
    ),
    indices=(
    """Dans l'ordre tu trouve&nbsp;:
    <ul>
    <li> Devant de la couverture du gros classeur
    <li> Devant de la couverture du premier des deux classeurs
    <li> 'chien' et 4
    <li> Derrire de la couverture du premier des deux classeurs
    <li> et devant de la couverture du deuxime des deux classeurs
    <li> 'homme' et 2
    <li> Derrire de la couverture du deuxime des deux classeurs
    <li> Derrire de la couverture du gros classeur
    <ul>
    <p>
    Heureusement, c'est plus court  crire en Python&nbsp;!
    """,
    
    ),
    )
    
add(name='rectangle toil',
    required=['carr toil', 'ordre des calculs', 'addition texte'],
    before="""Pour faire le carr toil, tu as fait
    <tt>print 5 * '*****\\n'</tt>
    <p>
    Mais si au lieu de mettre 5 toiles tu en veux 40,
    vas-tu les compter&nbsp;? Ou laisser le Python travailler&nbsp;?
    """,
    question="""Dis  Python d'afficher 5 fois&nbsp;:
    <ul>
    <li> l'addition de 40 fois le caractre '*'
    <li> le texte lui disant de revenir  la ligne
    </ul>    
    """,
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    multiply_required,
    plus_required,
    bracket_required,
    comma_rejected,
    lf_required,
    require('40', "Tu ne dois pas compter les '*', tu multiplies par 70"),
    require('5', "Tu dois afficher 5 fois la ligne de *"),
    python_answer_good(5*(40*'*'+'\n')+'\n'),
    python_display,
    ),    
    )

t = 10
square_top = 'a' + t*'H' + 'b\n'
square_bottom = 'c' + t*'B' + 'd\n'
square_middle = 'G' + t*' ' + 'D\n'

square = square_top + t*square_middle + square_bottom


add(name='carr haut',
    required=['addition texte', 'multiplication texte'],
    question="""Dis  Python d'afficher 'a' plus %d fois 'H' plus 'b'&nbsp;:
    <pre>%s</pre>""" % (t, square_top),
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    multiply_required,
    plus_required,
    comma_rejected,
    python_answer_good(square_top),
    python_display,
    ),    
    )

add(name='carr bas',
    required=['addition texte', 'multiplication texte'],
    question="""Dis  Python d'afficher 'c' plus %d fois 'B' plus 'd'&nbsp;:
    <pre>%s</pre>""" % (t, square_bottom),
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    multiply_required,
    plus_required,
    comma_rejected,
    python_answer_good(square_bottom),
    python_display,
    ),    
    )
    
add(name='carr milieu',
    required=['addition texte', 'multiplication texte'],
    question="""Dis  Python d'afficher 'G' plus %d fois '&nbsp;&nbsp;' (un espace) plus 'D'&nbsp;:
    <pre>%s</pre>""" % (t, square_middle),
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    multiply_required,
    plus_required,
    comma_rejected,
    python_answer_good(square_middle),
    python_display,
    ),    
    )
    

add(name='carr',
    required=['carr haut', 'carr milieu', 'carr bas', ' la ligne'],
    before="Le carr :<pre>" + square + "</pre>",
    question="""Pour afficher le carr, dis  Python
    d'afficher&nbsp;:
    <ul>
    <li> la ligne du haut plus un retour  la ligne
    <li> plus %d fois : la ligne du milieu plus un retour  la ligne
    <li> plus la ligne du bas
    </ul>
    """ % t,
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    multiply_required,
    plus_required,
    comma_rejected,
    lf_required,
    bracket_required,
    number_of_is('\\n', 2, "N'oublie pas les 2 retours  la ligne"),
    number_of_is('*', 4, "Il doit y avoir 4 multiplications"),
    number_of_is('10', 4, "Il doit y avoir 4 multiplications par 10"),
    python_answer_good(square),
    python_display,
    ),    
    )

add(name="addition classeur",
    required = ['classeur', 'addition texte'],
    before = """Comme les nombres et les textes, les classeurs
    peuvent s'additionner.
    Quand on ajoute deux classeurs, un nouveau classeur est
    cr contenant toutes les pages dans l'ordre,
    mme si des pages sont identiques.
    <p>
    <tt>["chien", 4, "homme", 2] + ["pieuvre", 8]</tt><br>
    donne le classeur&nbsp;:<br>
    <tt>["chien", 4, "homme", 2, "pieuvre", 8]</tt>
    """,
    question="""Dis  Python d'afficher la somme
    du classeur contenant les nombres 0 et 1 et 2 au classeur
    contenant les nombres 0 et 1.""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    plus_required,
    comma_required,
    number_of_is('[',2,
                 """Il doit y avoir 2 devants de couvertures de classeur
                 car on ajoute 2 classeurs"""),
    number_of_is(']',2,
                 """Il doit y avoir 2 derrires de couvertures de classeur
                 car on ajoute 2 classeurs"""),
    python_answer_good(str(range(3)+range(2))+'\n'),
    python_display,
    ),    
    ) 
    
    
add(name="multiplication classeur",
    required = ['classeur', 'multiplication texte'],
    before = """Comme les nombres et les textes, les classeurs
    peuvent tre multiplis par un nombre pour faire plein d'addition.
    <p>
    <tt>10 * [0]</tt> donne <tt>[0, 0, 0, 0, 0, 0, 0, 0, 0, 0]</tt>

    """,
    question = """Fais afficher <tt>[0, 1, 0, 1, 0, 1, 0, 1]</tt>
    en utilisant une multiplication.""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    multiply_required,
    comma_required,
    square_bracket_required,
    require('4', 'Il y a 4 fois le classeur contenant les nombres 0 et 1'),
    python_answer_good(str(4*[0,1])+'\n'),
    python_display,
    ),    
    )

two_spaces = """Il y a deux espaces au lieu d'un dans la phrase,
mais ce n'est pas grave."""

add(name="un grand chien",
    required=["multiplication texte", "print multiple"],
    question="""Fais afficher  Python la phrase&nbsp;:<br>
    <em>Un trs trs trs trs trs trs trs trs trs trs grand chien.</em><br>
    Plutt que d'crire 10 fois le mot <em>trs</em>
    il faut faire une multiplication.""",
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    multiply_required,
    require('10',
            'Il y a 10 fois le mot <em>trs</em>, il faut donc multiplier par 10.'),
    require('U', 'La phrase commence par une majuscule.'),
    require('.', 'La phrase se termine par un point.'),
    python_answer_good('Un' + ' trs'*10 + ' grand chien.\n', 'Parfait !'),
    python_answer_good('Un' + ' trs'*10 + '  grand chien.\n', two_spaces),
    python_answer_good('Un ' + ' trs'*10 + ' grand chien.\n', two_spaces),
    python_display,
    ),    
    )
    
add(name="gafirove",
    required=['ordre des calculs'],
    question="""5 <b>ga</b>rons et 3 <b>fi</b>lles mangent
    chacun 2 bonbons <b>ro</b>uges et 6 bonbons <b>ve</b>rts.<p>
    Combien ont-ils mangs de bonbons&nbsp;?
    Fait calculer et afficher la rponse par le python.""",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    plus_required,
    multiply_required,
    require(('5', '3', '2', '6'),
            """Comment le Python va calculer la rponse si tu ne
            lui donne pas les nombres indiqus dans le problme&nbsp;:
            5, 3, 2, 6"""),
    python_answer_good(str((5+3)*(2+6)) + '\n'),
    python_answer_bad(str(5+3*2+6) + '\n',
                      """Tu n'as pas dis au Python dans quel ordre
                      il faut faire les calculs.
                      Comme il considre les multiplications
                      plus importantes que les additions,
                      il a calcul&nbsp;: 5 + (3*2) + 6
                      et ce n'est pas ce que tu veux calculer"""),
    python_display,
    ),    
    indices=(
    """Comme ils ont tous mang le mme nombre de bonbons,
    le nombre de bonbons mangs est gal au nombre d'enfants
    multipli par le nombre de de bonbons que chaque enfant
    a mang""",
    """Le calcul  faire faire par le Python est donc&nbsp;:<br>
    nombre de garons plus nombre de filles<br>
    multipli par&nbsp;:<br>
    nombre de bonbon rouge plus nombre de bons verts.""",
    ),
    )

def range_required(value):
    return require(('range', str(value)),
                   """Utilise <tt>range</tt> pour faire une classeur
                   contenant les nombres de 0  %d""" % (value-1))

add(name="feuilleter un classeur",
    required=['les entiers', 'classeur dans classeur', 'addition classeur'],
    before="""Le python sait feuilleter un classeur page par page.
    Pour chaque page, il fait ce que tu lui demandes.
    <p>
    En franais on dirait&nbsp;:<br>
    <em>Pour chaque <tt>page</tt> dans le classeur <tt>['Un', 'grand', 'chien']</tt> : dis-moi '(' et <tt>page</tt> et ')'</em><br>
    <ul>
    <li> <em>Pour chaque</em> se dit <tt>for</tt> en Python.
    <li> <em>dans le classeur</em> se dit <tt>in</tt> en Python.
    <li> <em>:</em> se dit <tt>:</tt> en Python.
    </ul>
    <p>
    La phrase traduite ne Python devient&nbsp;:<br>
    <tt>for page in ['Un', 'grand', 'chien']: print '(', page, ')'</tt>
    <p>
    Le Python affichera&nbsp;:
    <pre>( Un )
( grand )
( chien )</pre>""",
    question="Fais afficher les nombres de 0  9 un par ligne.",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    for_required,
    range_required(10),
    python_answer_good('0\n1\n2\n3\n4\n5\n6\n7\n8\n9\n'),
    python_display,
    ),    
    )

add(name="compter de 2 en 2",
    required=['feuilleter un classeur'],
    before="""Pour compter de 2 en 2 c'est simple,
    on compte de 1 en 1 et on dit le double&nbsp;:
    <ul>
    <li> 0*2 : 0
    <li> 1*2 : 2
    <li> 2*2 : 4
    <li> 3*2 : 6
    <li> 4*2 : 8
    <li> 5*2 : 10
    <li> ...
    <li> 10*2 : 20
    </ul>""",
    question="Fais afficher les nombres paires de 0  20.",
    tests=(
    print_required,
    space_required,
    apostrophe_rejected,
    for_required,
    range_required(11),
    python_answer_good('0\n2\n4\n6\n8\n10\n12\n14\n16\n18\n20\n'),
    python_display,
    ),    
    )

triangle = '\n'.join([ i * "*" for i in range(8) ]) + '\n'

add(name='triangle toil',
    required=['feuilleter un classeur', 'multiplication texte'],
    question="Fais afficher le triangle suivant&nbsp;<pre>" + \
    triangle + '</pre>',
    tests=(
    print_required,
    space_required,
    apostrophe_required,
    for_required,
    range_required(8),
    python_answer_good(triangle),
    python_display,
    ),
    indices = (
    "Pour chaque nombre, tu fais afficher le nombre multipli par '*'",
    ),
    )
    
