#!/usr/bin/env python

import hooks

def check(h,expected):
    t = []
    h(t)
    if t == expected:
        return
    print(h)
    print(t)
    raise ValueError("Regtest Failed")

def simple_usage():
    h = hooks.new("hook regtest", "do not use")
    check(h,[])
    h.add(lambda x: x.append(1), fy="1")
    check(h,[1])
    h.add(lambda x: x.append(2), fy="2", before="1")
    check(h,[2,1])
    h.add(lambda x: x.append(3), fy="3", before=("1","2"))
    check(h,[3,2,1])
    h.add(lambda x: x.append(4), fy="4", after=("1","2"), always=True)
    check(h,[3,2,1,4])
    h.add(lambda x: x.append(5), fy="5", before=("1","4"), after="2")
    check(h,[3,2,5,1,4])
    def six(x):
        x.append(6)
    h.add(six, fy="6", before="*")
    check(h,[6,3,2,5,1,4])
    h.add(lambda x: x.append(7), fy="7", after="*")
    check(h,[6,3,2,5,1,4,7])
    h.add(lambda x: True, fy="8", before="5", after="2")
    check(h,[6,3,2,4])
    h.add(lambda x: x.append(11), fy="11", before=["9","6"], after="10")
    def nine(x):
        x.append(9)
    h.add(nine, fy="9", before="*")
    h.add(lambda x: x.append(10), fy="10", before="9")
    check(h,[10,11,6,9,3,2,4])
    def twelve(x):
        x.append(12)
    h.add(twelve, fy="12", after="9:nine", before="6:six")
    check(h,[10,11,9,12,6,3,2,4])
    def thirteen(x):
        x.append(13)
    h.add(thirteen, fy="12", after="12:twelve", before="6:six")
    check(h,[10,11,9,12,13,6,3,2,4])
    h.add(lambda x: x.append(14), fy="12", after="12:twelve",
          before="12:thirteen")
    check(h,[10,11,9,12,14,13,6,3,2,4])
    h.add(lambda x: x.append(15), fy="15", after="10", before="11")
    check(h,[10,15,11,9,12,14,13,6,3,2,4])

    h.add(lambda x: x.append(16), fy="16")
    h.add(lambda x: x.append(17), fy="17", after="16", before="**")
    check(h,[16,17,10,15,11,9,12,14,13,6,3,2,4])

    h.add(lambda x: x.append(18), fy="18", always=True)
    h.add(lambda x: x.append(19), fy="19", before="18", after="**", always=True)
    check(h,[16,17,10,15,11,9,12,14,13,6,3,2,4,19,18])

    hooks.remove("hook regtest")

def functionality_name():
    h = hooks.new("hook regtest2", "do not use2")
    h.add(lambda x: x.append(2))
    assert ' regtest ' in str(hooks.hooks)
    hooks.remove("hook regtest2")

def just_before_after():
    h = hooks.new("hook regtest3", "do not use3")
    check(h,[])
    h.add(lambda x: x.append(5), fy="5")
    check(h,[5])
    h.add(lambda x: x.append(4), fy="4")
    check(h,[4,5]) # Ordered by function name
    h.add(lambda x: x.append(2), fy="2", after="4")
    check(h,[4,2,5]) # 2 is the nearest possible to 4
    h.add(lambda x: x.append(1), fy="1", after="4")
    check(h,[4,1,2,5]) # Ordered by function name
    h.add(lambda x: x.append(7), fy="7", after="1")
    check(h,[4,1,7,2,5])
    h.add(lambda x: x.append(6), fy="6", after="1")
    check(h,[4,1,6,7,2,5])
    h.add(lambda x: x.append(8), fy="8", after="7", before="6")
    check(h,[4,1,7,8,6,2,5])

for test in (simple_usage, functionality_name, just_before_after):
    print(test)
    test()
    print("OK")
