"""
Add a hook to launch a thread for each function evaluated
"""
import threading
import hooks

def thread_evaluator(hook, context):
    context.threads = []
    context.main_thread = threading.currentThread()
    for function in hook.functions:
        if function.enabled:
            t = threading.Thread(target=function.function, args=(context,))
            t.start()
            context.threads.append(t)

thread = hooks.new(
    "thread",
    "Each function run in a thread, wait the end of all the threads",
    evaluator=thread_evaluator,
    args=("context",)
)

@hooks.add_to("action")
def launch_threads(context):
    thread(context)

@hooks.add_to("exit")
def exit(context):
    main_thread = getattr(context, "main_thread", None)
    if main_thread is threading.currentThread():
        for t in context.threads:
            print("Waiting %s" % t)
            t.join()
