"""
Check the state of the hook system
"""
import hooks

checker = hooks.new("checker",
                    "The functions check is the application state is fine.\n"
                    "Error are appended to the list_of_messages.",
                    args=('context', 'list_of_messages')
                )

@checker.add
def hook_defined(dummy_context, messages):
    for hook in hooks.hooks.hooks.values():
        if hook.documentation == '???':
            messages.append('Undefined hook: %s\n' % hook)

@hooks.add_to("args", after="*")
def args(context):
    messages = context.Translator(context.translator_text)
    checker(context, messages)
    if messages:
        print(''.join(messages))

@hooks.add_to("home")
def home(context, html):
    messages = context.Translator(html.server.translate, escape=True)
    checker(context, messages)
    if messages:
        html.append("<h2>Errors</h2>")
        html.append_raw(
                    ''.join('<pre style="background: #FDD; border:1px solid black">'
                            + m + '</pre>'
                            for m in messages))
