# -*- coding: utf-8 -*-
"""
Display the help about the command. Display it if no args or unknown arg.
The help content is defined by the 'help' hook.
"""
import types
import hooks

help = hooks.new("help",
                 "Append your help messages to list_of_messages",
                 args=('context', 'list_of_messages'))

@help.add(before="**")
def first(context, messages):
    messages.append("Help about {}:", context.args[0])

@help.add(after="***")
def help_help(dummy_context, messages):
    messages.append("-h, --help: display this help message")

def help_messages(self):
    messages = self.Translator(self.translator_text)
    help(self, messages)
    return '\n'.join(messages)

args = hooks.get("args")

@args.add(before="*")
def help_if_no_arg(context):
    context.help_messages = types.MethodType(help_messages, context)

    if len(context.args) == 1:
        print("No argument!")
        print(context.help_messages())
    else:
        if context.extract_arg(('--help', '-h')):
            print(context.help_messages())

@args.add(after="**")
def help_if_unknown_arg(context):
    if len(context.args) != 1:
        print("Unknown argument: %s" % context.args[1:])
        print(context.help_messages())

translations = (
    ('Help about {}:', {'fr': 'Aide à propos de {} :'}),
    )
