"""
Disable hook display on the web page.
If disabled show an error message.
"""
import hooks

@hooks.add_to("args")
def args(context):
    context.disable_http_hooks = context.extract_arg('--no-http-hooks')
    if context.disable_http_hooks:
        hooks.remove('HTTP.fy_http_hooks')

@hooks.add_to("url", before="HTTP.fy_http_hooks")
def disable_http_hook(context, server):
    if not context.disable_http_hooks:
        return
    if not server.path.startswith("/hooks"):
        return
    server.write("Forbiden!")
    return True

@hooks.add_to("help", after="HTTP.fy_http")
def help(dummy_context, messages):
    messages.append("--no-http-hooks: disable hook display on web")
