"""
Disabling of functionalities from the command line.
"""
import hooks

@hooks.add_to("args", before="*")
def args(context):
    fys = set(hooks.functionalities().keys())
    while True:
        v = context.extract_arg('--disable=')
        if v is False:
            break
        if v in fys:
            hooks.disable(v)
        elif v == '':
            print(' '.join(sorted(hooks.functionalities().keys())))
        else:
            print('Unknown functionality: %s' % v)

@hooks.add_to("help")
def help(c, messages):
    messages.append("--disable=functionality: Disable the functionality")
