"""
Option --debug to display the hooks on startup and exit.
"""
import hooks

args = hooks.get("args")

@args.add(before="**")
def debug_first(context):
    context.do_debug = context.extract_arg(('-d', '--debug'))
    if context.do_debug:
        print("Before:")
        print(hooks.hooks)

@args.add(after="***")
def debug_last(context):
    if context.do_debug:
        print("After:")
        print(hooks.hooks)

@hooks.add_to("help", after="*")
def help(dumy_context, messages):
    messages.append("-d, --debug: display hooks before and after")
