"""
Verify the number of arguments of functions
"""
import inspect
import hooks

@hooks.add_to("checker")
def verify_number_of_argument(dummy_context, messages):
    for hook in hooks.hooks.hooks.values():
        if hook.args is not None:
            hook.sort()
            for fct in hook.all_functions():
                if len(inspect.getargspec(fct.function).args) != len(hook.args):
                    messages.append("%s: bad number of args for %s\n" % (
                        hook.name, fct))
