"""
Evaluate the formula from the standard input
"""
import sys
import hooks

@hooks.add_to("args")
def args(context):
    if context.extract_arg('--calc-stdin'):
        @hooks.add_to("stdin")
        def stdin(context, line):
            print(context.calc_eval(line.strip()))
            sys.stdout.flush()

@hooks.add_to("help", after="STDIN.fy_stdin")
def help(dummy_context, messages):
    messages.append("--calc-stdin: add the formula evaluator to stdin")
