"""
The translator add a 'tip' on all displayed HTML element.
The tip indicate the functionality that has displayed the text.
"""
import hooks

tip = hooks.new("tip",
                "Append the tip content to server.tip",
                args=('context', 'server')
)

@hooks.add_to("translator_html", after="*")
def tr_tip(context, translator):
    if translator.text.startswith('<td'):
        return
    t = translator.text
    server = translator.server
    server.tip = context.Translator(context.translator_text)
    tip(context, server)
    tip_content = '<br>'.join(server.tip.content)
    translator.text = ('<div class="tip">' + t
                       + '<div class="tiptip">' + tip_content + '</div>'
                       + '</div>'
                   )

@tip.add
def add_functionnality(dummy_context, server):
    i = 7
    while True:
        fy = hooks.get_fy(level=i)
        if fy == 'hooks':
            fy = last
            break
        last = fy
        i += 1
    server.tip.append_raw('functionality: <a href="/functionalities/%s">%s</a>'
                          ' (<a href="?reload=%s">reload</a>)'
                          %  (fy, fy, fy))
    server.tip_functionality = fy

hooks.get("css").add(lambda c, css: css.append(
    """
    .tip:hover .tiptip {
    display: block ;
    }
    .tip .tiptip {
    display: none ;
    position: absolute ;
    border: 1px solid black ;
    color: #000 ;
    background: #DDF ;
    opacity: 0.8 ;
    font-size: 60% ;
    }
    """))
