"""
Automaticaly add a link on all hook and functionality name
between single cotes.
"""
import hooks

@hooks.add_to("translator_html")
def tr_link(context, translator):
    if context.no_tr_link:
        return
    txt = translator.text
    for hook in hooks.hooks.hooks:
        if txt == hook:
            txt = "'" + hook + "'"
        txt = txt.replace(
            "'" + hook + "'",
            '<a href="/hooks/%s">%s</a>' % (hook, hook))
    for fy in hooks.functionalities():
        if txt == fy:
            txt = "'" + fy + "'"
        txt = txt.replace(
            "'" + fy + "'",
            '<a href="/functionalities/%s">%s</a>' % (fy, fy))
    translator.text = txt

@hooks.add_to("args")
def disable_tr_link(context):
    context.no_tr_link = context.extract_arg('--no-tr-link')

hooks.get("help").add(lambda c, messages: messages.append(
    "--no-tr-link: Do not create automatic link into HTML"))

@hooks.add_to("menu", after="HTTP.fy_http_help")
def display_toggle_tr_link(context, html):
    s = '<li><a href="?tr_link='
    if context.no_tr_link:
        s += '1">Enable'
    else:
        s += '0">Disable'
    html.append(s + ' create links</a>')

@hooks.add_to("url", before="*")
def toggle_tr_link(context, server):
    tr_link = server.get_action('tr_link')
    if tr_link is not None:
        context.no_tr_link = tr_link == "0"
