"""
Add a sort button on all the HTML tables
"""
import hooks

hooks.get("js").add(lambda c, js: js.append(r"""
function get_sorted_column_and_dir(tbody)
{
  var column = localStorage[tbody.table_name] ;
  if ( ! column )
     column = '+0' ;
  return column ;
}

function get_sorted_column(tbody)
{
return Number(get_sorted_column_and_dir(tbody).substr(1)) ;
}

function get_sorted_up(tbody)
{
return get_sorted_column_and_dir(tbody).substr(0,1) === '+' ;
}

function update_sorted_headers(tbody)
{
  var sorted_col = get_sorted_column(tbody) ;
  for(var col=0; col<tbody.rows[0].cells.length; col++)
     {
       var cell = tbody.rows[0].cells[col] ;
       if ( sorted_col == col )
             cell.className += ' selected' ;
         else
             cell.className = cell.className.replace(/ selected/g, '') ;
       if ( sorted_col == col && ! get_sorted_up(tbody) )
             cell.lastChild.innerHTML = '&darr;' ;
       else
             cell.lastChild.innerHTML = '&uarr;' ;
    }
}

function set_sorted_column(tbody, col)
{
  var old_sort = get_sorted_column(tbody) ;
  if ( old_sort == col )
     localStorage[tbody.table_name] =
         (get_sorted_up(tbody) ? '-' : '+') + col ;
  else
     localStorage[tbody.table_name] = '+' + col ;
  update_sorted_headers(tbody) ;
}

function get_table_cell(event)
{
  var td = (event || window.event).target ;
  while(td.tagName != 'TD' && td.tagName != 'TH')
     td = td.parentNode ;
  return td ;
}

function set_sort_column(event)
{
  var td = get_table_cell(event) ;
  var tbody = td.parentNode.parentNode ;
  set_sorted_column(tbody, td.cellIndex) ;
  sort(tbody) ;
}

function sort(tbody)
{
  var col = get_sorted_column(tbody) ;
  var lines = [] ;
  while(tbody.childNodes[1])
     {
     if ( tbody.childNodes[1].tagName )
        lines.push(tbody.childNodes[1]) ;
     tbody.removeChild(tbody.childNodes[1]) ;
     }
  function key(x)
  {
    if ( isNaN(x) )
       return 'S' + x ;
    else
      {
       x = '            ' + (Number(x) + 2000000000) ;
       return 'N' + x.substr(x.length-10) ; // XXX only integers
      }
  }
  function cmp(aa, bb)
  {
      var a = key(aa.cells[col].textContent) ;
      var b = key(bb.cells[col].textContent) ;
      if ( a > b )
         return 1 ;
      if ( a < b )
         return -1 ;
      a = key(aa.cells[0].textContent) ;
      b = key(bb.cells[0].textContent) ;
      if ( a > b )
         return 1 ;
      if ( a < b )
         return -1 ;
      return 0 ;
  } ;
  lines.sort(cmp) ;
  if ( ! get_sorted_up(tbody) )
     lines.reverse() ;
  for(var i=0; i<lines.length; i++)
     tbody.appendChild(lines[i]) ;
}

function add_sort()
{
  var t = document.getElementsByTagName("TBODY") ;
  for(var i=0; i<t.length; i++)
   {
    t[i].table_name = t[i].rows[0].textContent ;
    for(var col=0; col<t[i].rows[0].cells.length; col++)
         t[i].rows[0].cells[col].innerHTML +=
               '<a onclick="javascript:set_sort_column(event)"></a>' ;
    update_sorted_headers(t[i]) ;
   sort(t[i]) ;
  }
}
document.getElementsByTagName("BODY")[0].onload = add_sort ;
"""))
