"""
Display statistics about source code
"""
import os
import hooks

def split(txt):
    txt = txt.strip().split(' ')
    txt[0] = int(txt[0])
    return txt

@hooks.add_to("stats")
def stats_lines(dummy_context, html):
    f = os.popen("wc -l */[!_]*.py *.py", "r")
    c = [split(nb) for nb in f]
    f.close()
    c.pop() # total
    histogram = [[] for i in range(max(tuple(zip(*c))[0])//10 + 1)]
    lens = []
    for nb, filename in c:
        histogram[nb//10].append(filename[:-3])
        lens.append(nb)
    s = ""
    for i, filenames in enumerate(histogram):
        nb = len(filenames)
        line = "%3d-%-3d  %s" % (i*10, (i+1)*10, "*" * nb)
        if nb <= 4:
            line += (20-len(line)) * ' ' + ' '.join(filenames)
        s += line + '\n'
    html.append(
        "<div>Number of lines of python source files<pre>%s</pre></div>" % s)
    html.append("<div>Number of lines: Average=%d Median=%d Total=%s</div>" % (
        sum(lens) // len(lens), sorted(lens)[len(lens)//2], sum(lens)))
